/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class ApexSfdcOnlyVisibilityTest
extends ValidationTest {
    private List<CompilationException> compileForSfdcTests(String[] trustedSourcesInSystemNamespace, String[] untrustedSourcesInEmptyNamespace) {
        ArrayList<SourceFile> allSources = new ArrayList<SourceFile>();
        for (String trustedSource : trustedSourcesInSystemNamespace) {
            allSources.add(SourceFile.builder().setTrusted(true).setBody(trustedSource).setNamespace(Namespaces.SYSTEM).build());
        }
        for (String untrustedSource : untrustedSourcesInEmptyNamespace) {
            allSources.add(SourceFile.builder().setTrusted(false).setBody(untrustedSource).setNamespace(Namespaces.EMPTY).build());
        }
        ApexCompiler compiler = this.tester.buildCompiler(ParserWrapper.Type.NAMED, allSources);
        compiler.compile();
        return compiler.getErrors();
    }

    private void assertSfdcOnlySuccess(String[] trustedSourcesInSystemNamespace, String[] untrustedSourcesInEmptyNamespace) {
        List<CompilationException> actualErrors = this.compileForSfdcTests(trustedSourcesInSystemNamespace, untrustedSourcesInEmptyNamespace);
        MatcherAssert.assertThat(actualErrors, (Matcher)Matchers.empty());
    }

    private void assertSfdcOnlyFailure(String[] trustedSourcesInSystemNamespace, String[] untrustedSourcesInEmptyNamespace, List<String> expectedErrorMessages) {
        List<CompilationException> actualErrors = this.compileForSfdcTests(trustedSourcesInSystemNamespace, untrustedSourcesInEmptyNamespace);
        MatcherAssert.assertThat(actualErrors, ErrorMatchers.containsErrors(expectedErrorMessages));
    }

    @Test
    void testVisibleForSfdcTypeFromTrusted() {
        this.assertSfdcOnlySuccess(new String[]{"@SfdcOnly global class Foo { }", "global class Bar { Foo f; }"}, new String[0]);
    }

    @Test
    void testNotVisibleForSfdcType() {
        this.assertSfdcOnlyFailure(new String[]{"@SfdcOnly global class Foo { }"}, new String[]{"global class Bar { Foo f; }"}, Collections.singletonList(I18nSupport.getLabel("type.not.visible", "System.Foo")));
    }

    @Test
    void testNotVisibleForSfdcMethod() {
        this.assertSfdcOnlyFailure(new String[]{"global class Foo { @SfdcOnly global static void Bar() { } }"}, new String[]{"global class Baz { { Foo.Bar(); } }"}, Collections.singletonList(I18nSupport.getLabel("method.not.visible", "void System.Foo.Bar()")));
    }

    @Test
    void testNotVisibleForMethodWhenTypeIsSfdc() {
        this.assertSfdcOnlyFailure(new String[]{"@SfdcOnly global class Foo { static global void m() { } }"}, new String[]{"public class Bar { { Foo.m(); } }"}, Collections.singletonList(I18nSupport.getLabel("method.not.visible", "void System.Foo.m()")));
    }

    @Test
    void testVisibleForSfdcDisabledMethod() {
        this.assertSfdcOnlySuccess(new String[]{"global virtual class Foo { @SfdcOnly(value='false') global static void Bar() { } }"}, new String[]{"public class Baz { { Foo.Bar(); } }"});
    }

    @Test
    void testVisibleForSfdcDisabledMethodWhenTypeIsSfdc() {
        this.assertSfdcOnlySuccess(new String[]{"@SfdcOnly global virtual class Foo { @SfdcOnly(value='false') global static void Bar() { } }"}, new String[]{"public class Baz { { Foo.Bar(); } }"});
    }

    @Test
    void testVisibleTypeFromInternalSfdcOrg() {
        this.tester.getAccessEvaluator().setHasInternalSfdc(true);
        this.assertSfdcOnlySuccess(new String[]{"@SfdcOnly global class Foo { }"}, new String[]{"public class Bar { { Foo f; } }"});
    }

    @Test
    void testVisibleMethodFromInternalSfdcOrg() {
        this.tester.getAccessEvaluator().setHasInternalSfdc(true);
        this.assertSfdcOnlySuccess(new String[]{"global class Foo { @SfdcOnly static global void m() { } }"}, new String[]{"public class Bar { { Foo.m(); } }"});
    }
}

