/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;

public class StandardParentTable
implements ParentTable {
    private TypeInfo superType;
    private Set<TypeInfo> immediateInterfaces = Collections.emptySet();
    private Set<TypeInfo> allInterfaces = Collections.emptySet();
    private boolean resolved = false;
    private boolean checkSuperVisibility;

    public static ParentTable emptyTable() {
        StandardParentTable parentTable = new StandardParentTable();
        parentTable.superType = null;
        parentTable.resolved = true;
        return parentTable;
    }

    @Override
    public TypeInfo superType() {
        assert (this.resolved) : "can't get super type as parent table has not been resolved";
        return this.superType;
    }

    @Override
    public Set<TypeInfo> immediateInterfaces() {
        assert (this.resolved) : "can't get immediate interfaces as parent table has not been resolved";
        return this.immediateInterfaces;
    }

    @Override
    public Set<TypeInfo> allInterfaces() {
        assert (this.resolved) : "can't get all interfaces as parent table has not been resolved";
        return this.allInterfaces;
    }

    @Override
    public void resolve(TypeInfo superType, Set<TypeInfo> immediateInterfaces, boolean checkSuperVisibility) {
        assert (superType == null || superType.parents().isResolved()) : "superType hasn't been resolved";
        this.superType = superType;
        this.immediateInterfaces = immediateInterfaces;
        this.checkSuperVisibility = checkSuperVisibility;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (superType != null) {
            builder.addAll(superType.parents().allInterfaces());
        }
        for (TypeInfo interfaceType : immediateInterfaces) {
            assert (interfaceType.parents().isResolved()) : "interfaceType hasn't been resolved";
            Set<TypeInfo> inheritedInterfaces = interfaceType.parents().allInterfaces();
            builder.addAll(inheritedInterfaces);
        }
        builder.addAll(immediateInterfaces);
        this.allInterfaces = builder.build();
        this.resolved = true;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean checkSuperVisibility() {
        return this.checkSuperVisibility;
    }
}

