/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculator;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public class ParentTableFactory {
    private ParentTableFactory() {
    }

    public static ParentTable create(TypeInfo superType) {
        return ParentTableFactory.create(superType, Collections.emptySet());
    }

    public static ParentTable create(TypeInfo superType, TypeInfo ... interfaces) {
        return ParentTableFactory.create(superType, Sets.newHashSet(interfaces));
    }

    public static ParentTable create(TypeInfo superType, Set<TypeInfo> interfaces) {
        StandardParentTable table = new StandardParentTable();
        table.resolve(superType, interfaces, true);
        return table;
    }

    public static void resolve(Multimap<TypeInfo, CompilationException> errors, SymbolResolver symbols, TypeInfo type) {
        ParentTableCalculator calculator = new ParentTableCalculator(errors, symbols);
        calculator.resolve(type);
    }
}

