/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.LinkedListMultimap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;

public class ParentTableCalculatorTest {
    private SymbolResolver symbols;

    @BeforeMethod
    public final void setUp() {
        this.symbols = TestSymbolResolvers.createTestSymbols();
    }

    void assertInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        MatcherAssert.assertThat((Object)type.parents().isResolved(), (Matcher)Matchers.is((Object)false));
        LinkedListMultimap<TypeInfo, CompilationException> errors = LinkedListMultimap.create();
        this.symbols.add(type);
        for (TypeInfo additionalType : additionalTypes) {
            this.symbols.add(additionalType);
        }
        ParentTableFactory.resolve(errors, this.symbols, type);
        MatcherAssert.assertThat((String)message, errors, ErrorMatchers.containsMultiErrors(expectedErrors));
        MatcherAssert.assertThat((Object)type.parents().isResolved(), (Matcher)Matchers.is((Object)true));
    }

    void assertValid(TypeInfo type, List<TypeInfo> additionalTypes, Matcher<Iterable<? extends TypeInfo>> allInterfaces, Matcher<Iterable<? extends TypeInfo>> immediateInterfaces, TypeInfo superType) {
        MatcherAssert.assertThat((Object)type.parents().isResolved(), (Matcher)Matchers.is((Object)false));
        LinkedListMultimap<TypeInfo, CompilationException> errors = LinkedListMultimap.create();
        this.symbols.add(type);
        for (TypeInfo additionalType : additionalTypes) {
            this.symbols.add(additionalType);
        }
        ParentTableFactory.resolve(errors, this.symbols, type);
        MatcherAssert.assertThat(errors.asMap().values(), (Matcher)Matchers.empty());
        ParentTable parents = type.parents();
        MatcherAssert.assertThat(parents.allInterfaces(), allInterfaces);
        MatcherAssert.assertThat(parents.immediateInterfaces(), immediateInterfaces);
        MatcherAssert.assertThat((Object)parents.superType(), IsType.isType(superType));
    }
}

