/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.parent.DuplicateGenericInterfaceCalculator;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class ParentTableCalculator {
    private static final Set<TypeInfo> UNRESOLVED_INTERFACES = ImmutableSet.of(UnresolvedTypeInfoFactory.get());
    private static final Set<TypeInfo> TRIGGER_INTERFACES = ImmutableSet.of(InternalTypeInfos.TRIGGER);
    private static final Set<Equivalence.Wrapper<? extends TypeInfo>> ILLEGAL_EXPLICIT_EXTEND_TYPES = ImmutableSet.of(InternalTypeInfos.APEX_OBJECT.getEquivalenceWrapper(), TypeInfos.OBJECT.getEquivalenceWrapper(), InternalTypeInfos.ENUM.getEquivalenceWrapper());
    private static final Set<Equivalence.Wrapper<? extends TypeInfo>> TRUSTED_ONLY_EXPLICIT_EXTEND_TYPES = ImmutableSet.of(InternalTypeInfos.APEX_EXCEPTION.getEquivalenceWrapper());
    private final Multimap<TypeInfo, CompilationException> errors;
    private final SymbolResolver symbols;
    private final Set<TypeInfo> visitedTypes;
    private boolean hasCycle;

    ParentTableCalculator(Multimap<TypeInfo, CompilationException> errors, SymbolResolver symbols) {
        this.errors = errors;
        this.symbols = symbols;
        this.visitedTypes = Sets.newHashSet();
        this.hasCycle = false;
    }

    private boolean isArrayRef(TypeRef typeRef) {
        return typeRef.match(new TypeRef.MatchBlock<Boolean>(){

            @Override
            public Boolean _case(TypeRef.ClassTypeRef classType) {
                return false;
            }

            @Override
            public Boolean _case(TypeRef.ArrayTypeRef x) {
                return true;
            }
        });
    }

    private boolean isExplicitExtend(TypeInfo type) {
        return type.getCodeUnitDetails().getSuperTypeRef().isPresent();
    }

    private boolean isIllegalExplicitExtendType(TypeInfo superType, boolean isTrustedSource) {
        return ILLEGAL_EXPLICIT_EXTEND_TYPES.contains(superType.getEquivalenceWrapper()) || !isTrustedSource && TRUSTED_ONLY_EXPLICIT_EXTEND_TYPES.contains(superType.getEquivalenceWrapper());
    }

    public void resolve(TypeInfo type) {
        boolean checkSuperVisibility;
        TypeInfo actualSuperType;
        Set<Object> interfaces;
        TypeInfo superType;
        if (type == null) {
            return;
        }
        if (this.visitedTypes.contains(type)) {
            this.hasCycle = true;
            return;
        }
        this.visitedTypes.add(type);
        if (type.parents().isResolved()) {
            return;
        }
        if (this.errors.containsKey(type)) {
            type.parents().resolve(TypeInfos.OBJECT, Collections.emptySet(), true);
            return;
        }
        switch (type.getUnitType()) {
            case CLASS: {
                superType = type.getCodeUnitDetails().getSuperTypeRef().map(superRef -> {
                    if (this.isArrayRef((TypeRef)superRef)) {
                        this.errors.put(type, new SemanticException(Location.from(superRef), I18nSupport.getLabel("array.ref.not.allowed", PrinterUtil.print(superRef))));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    TypeInfo foundType = this.symbols.lookupTypeInfo(type, (TypeRef)superRef);
                    if (!foundType.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Location.from(superRef), UnresolvedErrorCalculator.getErrors(foundType)));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    if (foundType.getUnitType() != UnitType.CLASS) {
                        this.errors.put(type, new SemanticException(Location.from(superRef), I18nSupport.getLabel("invalid.class", PrinterUtil.print(superRef))));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    return foundType;
                }).orElseGet(() -> {
                    if (TypeNameUtil.isException(type.getApexName())) {
                        this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.extend.exception", type)));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    return TypeInfos.OBJECT;
                });
                HashSet<TypeInfo> builder = new HashSet<TypeInfo>();
                for (TypeRef interfaceRef : type.getCodeUnitDetails().getInterfaceTypeRefs()) {
                    if (this.isArrayRef(interfaceRef)) {
                        this.errors.put(type, new SemanticException(Location.from(interfaceRef), I18nSupport.getLabel("array.ref.not.allowed", PrinterUtil.print(interfaceRef))));
                        continue;
                    }
                    TypeInfo interfaceType2 = this.symbols.lookupTypeInfo(type, interfaceRef);
                    if (!interfaceType2.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Location.from(interfaceRef), UnresolvedErrorCalculator.getErrors(interfaceType2)));
                        continue;
                    }
                    if (interfaceType2.getUnitType() != UnitType.INTERFACE) {
                        this.errors.put(type, new SemanticException(Location.from(interfaceRef), I18nSupport.getLabel("invalid.interface", PrinterUtil.print(interfaceRef))));
                        continue;
                    }
                    if (TypeInfoEquivalence.containsEquivalent(builder, interfaceType2)) {
                        this.errors.put(type, new SemanticException(Location.from(interfaceRef), I18nSupport.getLabel("interface.already.implemented", PrinterUtil.print(interfaceRef))));
                        continue;
                    }
                    builder.add(interfaceType2);
                }
                interfaces = ImmutableSet.copyOf(builder);
                break;
            }
            case ENUM: {
                superType = InternalTypeInfos.ENUM;
                interfaces = ImmutableSet.of();
                break;
            }
            case INTERFACE: {
                superType = TypeInfos.OBJECT;
                assert (type.getCodeUnitDetails().getInterfaceTypeRefs().size() <= 1) : "extending multiple interfaces";
                interfaces = type.getCodeUnitDetails().getInterfaceTypeRefs().stream().findFirst().map(superRef -> {
                    if (this.isArrayRef((TypeRef)superRef)) {
                        this.errors.put(type, new SemanticException(Location.from(superRef), I18nSupport.getLabel("array.ref.not.allowed", PrinterUtil.print(superRef))));
                        return UNRESOLVED_INTERFACES;
                    }
                    TypeInfo foundType = this.symbols.lookupTypeInfo(type, (TypeRef)superRef);
                    if (!foundType.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Location.from(superRef), UnresolvedErrorCalculator.getErrors(foundType)));
                        return UNRESOLVED_INTERFACES;
                    }
                    if (foundType.getUnitType() != UnitType.INTERFACE) {
                        this.errors.put(type, new SemanticException(Location.from(superRef), I18nSupport.getLabel("invalid.interface", PrinterUtil.print(superRef))));
                        return UNRESOLVED_INTERFACES;
                    }
                    return ImmutableSet.of(foundType);
                }).orElse(ImmutableSet.of());
                break;
            }
            case ANONYMOUS: {
                superType = TypeInfos.OBJECT;
                interfaces = ImmutableSet.of();
                break;
            }
            case TRIGGER: {
                superType = TypeInfos.OBJECT;
                interfaces = TRIGGER_INTERFACES;
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
        if (TypeInfoEquivalence.isEquivalent(superType, TypeInfos.EXCEPTION) && !TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_EXCEPTION)) {
            actualSuperType = this.symbols.lookupTypeInfo(type, InternalTypeInfos.APEX_EXCEPTION);
            checkSuperVisibility = false;
        } else if (type.getUnitType() == UnitType.CLASS && TypeInfoEquivalence.isEquivalent(superType, TypeInfos.OBJECT) && !TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_OBJECT)) {
            actualSuperType = this.symbols.lookupTypeInfo(type, InternalTypeInfos.APEX_OBJECT);
            checkSuperVisibility = false;
        } else {
            actualSuperType = superType;
            checkSuperVisibility = true;
        }
        boolean isSuperTypeValid = this.resolveParent(type, actualSuperType, "invalid.super.type");
        boolean areInterfacesValid = true;
        for (TypeInfo typeInfo : interfaces) {
            areInterfacesValid &= this.resolveParent(type, typeInfo, "invalid.interface");
            if (!TypeInfoUtil.isInnerType(type) || !GenericTypeInfoUtil.isGenericType(typeInfo) || Distance.get().getDistance(type, GenericTypeInfoUtil.getRootType(typeInfo), (TypeInfo)InternalTypeInfos.DATABASE_BATCHABLE) < 0) continue;
            this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("database.batchable.must.be.top.level")));
        }
        if (isSuperTypeValid) {
            if (ExceptionTypeInfoUtil.isException(type, superType) && !TypeNameUtil.isException(type.getApexName())) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.end.with.exception", type)));
            } else if (!ExceptionTypeInfoUtil.isException(type, superType) && TypeNameUtil.isException(type.getApexName())) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.extend.exception", superType)));
            } else {
                boolean isIllegalExtend;
                boolean bl = isIllegalExtend = superType.getModifiers().none(ModifierTypeInfos.ABSTRACT, ModifierTypeInfos.VIRTUAL) && superType.getUnitType() != UnitType.INTERFACE && !TypeInfoUtil.isInnerTypeOfAnonymous(superType);
                if (isIllegalExtend || this.isExplicitExtend(type) && this.isIllegalExplicitExtendType(superType, type.getCodeUnitDetails().isFileBased())) {
                    this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.final.super.type", superType)));
                }
            }
        }
        if (isSuperTypeValid && areInterfacesValid && !this.errors.containsKey(type)) {
            type.parents().resolve(actualSuperType, interfaces, checkSuperVisibility);
            DuplicateGenericInterfaceCalculator.calculate(type, this.errors);
        } else {
            ScalarTypeInfo validSuperType = actualSuperType.isResolved() && actualSuperType.parents().isResolved() ? actualSuperType : TypeInfos.OBJECT;
            Set<TypeInfo> set = interfaces.stream().filter(interfaceType -> interfaceType.isResolved() && interfaceType.parents().isResolved()).collect(MoreIterables.toUnmodifiableOrderedSet(interfaces.size()));
            type.parents().resolve(validSuperType, set, checkSuperVisibility);
        }
    }

    private boolean resolveParent(TypeInfo type, TypeInfo parentType, String errorLabel) {
        if (parentType == null) {
            return true;
        }
        if (!parentType.isResolved()) {
            return false;
        }
        TypeInfo rawSuperType = GenericTypeInfoUtil.getRootType(parentType);
        if (!rawSuperType.parents().isResolved()) {
            this.resolve(rawSuperType);
            if (this.hasCycle) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("circular.definition", parentType)));
                return false;
            }
            if (!rawSuperType.parents().isResolved()) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel(errorLabel, parentType)));
                return false;
            }
        }
        return true;
    }
}

