/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InterfaceExtendsTest
extends ParentTableCalculatorTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"interface with unresolved super type", TypeInfoTester.createInterfaceBarExtendsFoo(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", "Foo"))}, {"interface with bad super type", TypeInfoTester.createInterfaceBarExtendsFoo(), ImmutableList.of(TypeInfoTester.ENUM_FOO), ImmutableList.of(I18nSupport.getLabel("invalid.interface", "Foo"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testInterface() {
        TypeInfo interfaceFoo = TestTypeInfos.create(CompilationUnitBuilder.emptyInterface((String)"Foo"));
        this.assertValid(interfaceFoo, Collections.emptyList(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TypeInfos.OBJECT);
    }

    @Test
    public void testInterfaceWithSuperInterface() {
        TypeInfo interfaceBarExtendsFoo = TypeInfoTester.createInterfaceBarExtendsFoo();
        this.assertValid(interfaceBarExtendsFoo, ImmutableList.of(TypeInfoTester.INTERFACE_FOO), (Matcher<Iterable<? extends TypeInfo>>)Matchers.contains((Object[])new TypeInfo[]{TypeInfoTester.INTERFACE_FOO}), (Matcher<Iterable<? extends TypeInfo>>)Matchers.contains((Object[])new TypeInfo[]{TypeInfoTester.INTERFACE_FOO}), TypeInfos.OBJECT);
    }

    @Test
    public void testInterfaceWithSuperSuperInterface() {
        TypeInfo interfaceBarExtendsFoo = TypeInfoTester.createInterfaceBarExtendsFoo();
        TypeInfo interfaceBazExtendsBarExtendsFooType = TypeInfoTester.createInterfaceBazExtendsBar();
        this.assertValid(interfaceBazExtendsBarExtendsFooType, ImmutableList.of(TypeInfoTester.INTERFACE_FOO, interfaceBarExtendsFoo), (Matcher<Iterable<? extends TypeInfo>>)Matchers.contains((Object[])new TypeInfo[]{TypeInfoTester.INTERFACE_FOO, interfaceBarExtendsFoo}), (Matcher<Iterable<? extends TypeInfo>>)Matchers.contains((Object[])new TypeInfo[]{interfaceBarExtendsFoo}), TypeInfos.OBJECT);
    }
}

