/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InterfaceExtendsGenericInterfaceTest
extends ParentTableCalculatorTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"interface with unresolved arguments for parameterized interface", TypeInfoTester.createInterfaceBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.INTERFACE_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", TypeInfoTester.CLASS_BAZ))}, {"interface with type arguments for not parameterized interface", TypeInfoTester.createInterfaceBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO), ImmutableList.of(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeInfoTester.INTERFACE_FOO))}, {"interface with mismatch arguments for parameterized interface", TypeInfoTester.createInterfaceBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U), ImmutableList.of(I18nSupport.getLabel("invalid.parameterized.type.count", TypeInfoTester.INTERFACE_FOO_U, 1, 2))}, {"interface with no type arguments for parameterized interface", TypeInfoTester.createInterfaceBarExtendsFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", TypeInfoTester.INTERFACE_FOO_U))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testValid() {
        TypeInfo interfaceBarExtendsParameterizedFoo = TypeInfoTester.createInterfaceBarExtendsGenericFoo();
        GenericTypeInfo interfaceFooBazString = GenericTypeInfo.builder().setUnreifiedType(TypeInfoTester.INTERFACE_FOO_U_T).setTypeArguments(TypeInfoTester.CLASS_BAZ, TypeInfos.STRING).build();
        this.assertValid(interfaceBarExtendsParameterizedFoo, ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U_T), IsType.containsTypes(interfaceFooBazString), IsType.containsTypes(interfaceFooBazString), TypeInfos.OBJECT);
    }

    @Test
    public void testReifyParents() {
        GenericTypeInfo interfaceBarUExtendsFooU = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.builder((String)"Bar").setSuperType(JadtTester.type((String)"Foo", (String[])new String[]{"T"})).buildInterface())).setUnitType(UnitType.INTERFACE)).setTypeArguments(ArgumentTypeInfos.T).setModifiers(ModifierGroups.GLOBAL_VIRTUAL)).build();
        this.assertValid(interfaceBarUExtendsFooU, Collections.singletonList(TypeInfoTester.INTERFACE_FOO_U), IsType.containsTypes(TypeInfoTester.INTERFACE_FOO_U), IsType.containsTypes(TypeInfoTester.INTERFACE_FOO_U), TypeInfos.OBJECT);
        GenericTypeInfo reifiedBar = GenericTypeInfoFactory.create((TypeInfo)interfaceBarUExtendsFooU, TypeInfos.STRING);
        MatcherAssert.assertThat(reifiedBar.parents().immediateInterfaces(), IsType.containsTypes(GenericTypeInfoFactory.create((TypeInfo)TypeInfoTester.INTERFACE_FOO_U, TypeInfos.STRING)));
    }
}

