/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IllegalClassExtendsTest
extends ParentTableCalculatorTest {
    private TypeInfo createClassFooExtendsObject() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Foo").setSuperType(JadtTester.type((String)"Object", (String[])new String[0])).buildClass());
    }

    private TypeInfo createClassFooExtendsApexObject() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Foo").setSuperType(JadtTester.type((String)"ApexBaseClass", (String[])new String[0])).buildClass());
    }

    private TypeInfo createClassFooExtendsApexException() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"FooException").setSuperType(JadtTester.type((String)"ApexBaseException", (String[])new String[0])).buildClass());
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"cannot extend user class that isn't virtual/abstract ie class is final", TypeInfoTester.createClassFooExtendsBar(), ImmutableList.of(TypeInfoTester.CLASS_FINAL_BAR), ImmutableList.of(I18nSupport.getLabel("invalid.final.super.type", "Bar"))}, {"cannot extend object", this.createClassFooExtendsObject(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.final.super.type", "Object"))}, {"cannot extend apex base class", this.createClassFooExtendsApexObject(), ImmutableList.of(TypeInfoTester.createApexObject()), ImmutableList.of(I18nSupport.getLabel("invalid.final.super.type", "System.ApexBaseClass"))}, {"cannot extend apex base exception", this.createClassFooExtendsApexException(), ImmutableList.of(TypeInfoTester.createApexException()), ImmutableList.of(I18nSupport.getLabel("invalid.final.super.type", "System.ApexBaseException"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }
}

