/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassExtendsGenericClassTest
extends ParentTableCalculatorTest {
    private TypeInfo createBarExtendsGenericString() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Bar").setSuperType(JadtTester.type((String)"String", (String[])new String[]{"Integer"})).buildClass());
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"class with unresolved arguments for parameterized class", TypeInfoTester.createClassBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", TypeInfoTester.CLASS_BAZ))}, {"class with mismatch arguments for parameterized class", TypeInfoTester.createClassBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.CLASS_FOO_U), ImmutableList.of(I18nSupport.getLabel("invalid.parameterized.type.count", TypeInfoTester.CLASS_FOO_U, 1, 2))}, {"class with type arguments for not parameterized class", TypeInfoTester.createClassBarExtendsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.CLASS_FOO), ImmutableList.of(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeInfoTester.CLASS_FOO))}, {"class with no type arguments for parameterized class", TypeInfoTester.createClassBarExtendsFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.CLASS_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", TypeInfoTester.CLASS_FOO_U_T))}, {"class with type arguments for not parameterized built in types", this.createBarExtendsGenericString(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeInfos.STRING))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testValid() {
        TypeInfo classBarExtendsGenericFoo = TypeInfoTester.createClassBarExtendsGenericFoo();
        GenericTypeInfo classFooBazString = GenericTypeInfo.builder().setUnreifiedType(TypeInfoTester.CLASS_FOO_U_T).setTypeArguments(TypeInfoTester.CLASS_BAZ, TypeInfos.STRING).build();
        this.assertValid(classBarExtendsGenericFoo, ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.CLASS_FOO_U_T), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), classFooBazString);
    }

    @Test
    public void testReifyParents() {
        GenericTypeInfo classBarUExtendsFooU = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.builder((String)"Bar").setSuperType(JadtTester.type((String)"Foo", (String[])new String[]{"T"})).buildClass())).setTypeArguments(ArgumentTypeInfos.T).setModifiers(ModifierGroups.GLOBAL_VIRTUAL)).build();
        this.assertValid(classBarUExtendsFooU, Collections.singletonList(TypeInfoTester.CLASS_FOO_U), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TypeInfoTester.CLASS_FOO_U);
        GenericTypeInfo reifiedBar = GenericTypeInfoFactory.create((TypeInfo)classBarUExtendsFooU, TypeInfos.STRING);
        MatcherAssert.assertThat((Object)reifiedBar.parents().superType(), IsType.isType(GenericTypeInfoFactory.create((TypeInfo)TypeInfoTester.CLASS_FOO_U, TypeInfos.STRING)));
    }
}

