/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TypeNameUtilTest {
    private static final Namespace NAMESPACE = Namespaces.create("namespace", "module");
    private static final Namespace NULL_NAMESPACE = null;
    private static final String NULL_STRING = null;

    @Test(expectedExceptions={AssertionError.class})
    public void testNullCreateTypeSignature() {
        TypeNameUtil.createTypeSignature(null);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testEmptyCreateTypeSignature() {
        TypeNameUtil.createTypeSignature("");
    }

    @DataProvider
    Object[][] createTypeSignatureData() {
        return new Object[][]{{"foo", "Lfoo;"}};
    }

    @Test(dataProvider="createTypeSignatureData")
    public void testCreateTypeSignature(String input, String expected) {
        MatcherAssert.assertThat((Object)TypeNameUtil.createTypeSignature(input), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testNonGenericBytecodeName() {
        MatcherAssert.assertThat((Object)TypeNameUtil.erasedBytecodeName(TypeInfos.STRING), (Matcher)Matchers.is((Object)"java/lang/String"));
        MatcherAssert.assertThat((Object)TypeNameUtil.erasedBytecodeName(ReifiedTypeInfos.STRING_LIST), (Matcher)Matchers.is((Object)"com/salesforce/api/fast/List"));
    }

    @Test
    public void testNonGenericBytecodeNames() {
        MatcherAssert.assertThat(Arrays.asList(TypeNameUtil.erasedBytecodeNames(TypeInfos.STRING, ReifiedTypeInfos.STRING_LIST)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"com/salesforce/api/fast/List", "java/lang/String"}));
    }

    @Test
    public void testInnerType() {
        MatcherAssert.assertThat((Object)TypeNameUtil.toInnerTypeLower("outer", "inner"), (Matcher)Matchers.is((Object)"outer$inner"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInnerTypeNullEnclosingType() {
        TypeNameUtil.toInnerTypeLower(null, "inner");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInnerTypeEmptyEnclosingType() {
        TypeNameUtil.toInnerTypeLower("", "inner");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInnerTypeNullInnerType() {
        TypeNameUtil.toInnerTypeLower("outer", null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInnerTypeEmptyInnerType() {
        TypeNameUtil.toInnerTypeLower("outer", "");
    }

    @Test
    public void testNamespaceType() {
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower(Namespaces.SYSTEM, "type"), (Matcher)Matchers.is((Object)"system/type"));
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower(Namespaces.SCHEMA, "type"), (Matcher)Matchers.is((Object)"schema/type"));
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower(Namespaces.EMPTY, "type"), (Matcher)Matchers.is((Object)"type"));
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower(NAMESPACE, "type"), (Matcher)Matchers.is((Object)"namespace__module/type"));
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower(NULL_NAMESPACE, "type"), (Matcher)Matchers.is((Object)"type"));
    }

    @Test
    public void testNamespaceString() {
        MatcherAssert.assertThat((Object)TypeNameUtil.toNamespaceLower("namespace", "type"), (Matcher)Matchers.is((Object)"namespace/type"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNamespaceStringNull() {
        TypeNameUtil.toNamespaceLower("", "type");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNamespaceStringEmpty() {
        TypeNameUtil.toNamespaceLower(NULL_STRING, "type");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNamespaceNullType() {
        TypeNameUtil.toNamespaceLower(NAMESPACE, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNamespaceStringNullType() {
        TypeNameUtil.toNamespaceLower("namespace", null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNamespaceEmptyType() {
        TypeNameUtil.toNamespaceLower(NAMESPACE, "");
    }

    @Test
    public void testIsApexBaseException() {
        MatcherAssert.assertThat((Object)TypeNameUtil.isApexBaseException("system.apexbaseexception"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeNameUtil.isApexBaseException("System.ApexBaseException"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeNameUtil.isApexBaseException("ApexBaseException"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)TypeNameUtil.isApexBaseException("foo.ApexBaseException"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsException() {
        MatcherAssert.assertThat((Object)TypeNameUtil.isException("fooEXCEPTION"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeNameUtil.isException("fooException"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeNameUtil.isException("exception"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TypeNameUtil.isException("exceptionFoo"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testBytecodeNameWithStrings() {
        MatcherAssert.assertThat((Object)TypeNameUtil.createBytecodeName("foo", new String[0]), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)TypeNameUtil.createBytecodeName("foo", "bar"), (Matcher)Matchers.is((Object)"foo$$lbar$$r"));
        MatcherAssert.assertThat((Object)TypeNameUtil.createBytecodeName("foo", "bar", "car"), (Matcher)Matchers.is((Object)"foo$$lbar$$ccar$$r"));
    }
}

