/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import apex.jorje.services.MyInterner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class TypeNameUtil {
    public static final Predicate<TypeInfo> HAS_PLACEHOLDER = type -> type instanceof ArgumentTypeInfo;
    private static final Pattern APEX_BASE_EXCEPTION = Pattern.compile("(?i)system\\.apexbaseexception");
    private static final Predicate<String> CHECK_GENERIC = s -> s.contains("$$");
    private static final Function<TypeInfo, String> TO_UNPARAMETERIZED_BYTECODE_NAME = type -> GenericTypeInfoUtil.getRootType(type).getBytecodeName();
    private static final Pattern EXCEPTION = Pattern.compile(".*(?i)exception$");

    private TypeNameUtil() {
    }

    public static String createApexName(TypeNameProvider type, List<TypeInfo> argumentTypes) {
        return argumentTypes.isEmpty() ? type.getApexName() : (TypeInfoUtil.containsPlaceholders(argumentTypes) ? type.getApexName() : TypeNameUtil.createName(type, argumentTypes, TypeInfo.TO_APEX_NAME, new StringJoiner(", ", "<", ">")));
    }

    public static String createApexNameWithPlaceHolders(TypeNameProvider type, List<TypeInfo> argumentTypes) {
        return argumentTypes.isEmpty() ? type.getApexName() : TypeNameUtil.createName(type, argumentTypes, TypeInfo.TO_APEX_NAME, new StringJoiner(", ", "<", ">"));
    }

    public static String createBytecodeName(TypeNameProvider type, List<TypeInfo> argumentTypes) {
        return argumentTypes.isEmpty() ? type.getBytecodeName() : (TypeInfoUtil.containsPlaceholders(argumentTypes) ? type.getBytecodeName() : TypeNameUtil.createName(type, argumentTypes, TypeInfo.TO_BYTECODE_NAME, new StringJoiner("$$c", "$$l", "$$r")));
    }

    @SfdcCalled
    public static String createBytecodeName(String type, String ... argumentTypes) {
        return TypeNameUtil.createBytecodeName(type, ImmutableList.copyOf(argumentTypes));
    }

    public static String createBytecodeName(String type, List<String> argumentTypes) {
        return argumentTypes.isEmpty() ? type : type + LessStrings.toString(argumentTypes, new StringJoiner("$$c", "$$l", "$$r"));
    }

    private static String createName(TypeNameProvider type, List<TypeInfo> argumentTypes, Function<TypeNameProvider, String> function, StringJoiner joiner) {
        String arguments = LessStrings.toString(argumentTypes, function, joiner);
        return function.apply(type) + arguments;
    }

    public static String createDynamicName(String separator, String ... names) {
        StringJoiner joiner = new StringJoiner(separator);
        for (int i = 0; i < names.length; ++i) {
            if (Strings.isNullOrEmpty(names[i])) continue;
            joiner.add(names[i]);
        }
        return joiner.toString();
    }

    public static String createTypeSignature(String bytecodeName) {
        assert (!Strings.isNullOrEmpty(bytecodeName)) : "no bytecode name";
        return "L" + bytecodeName + ";";
    }

    public static String nonGenericApexName(GenericTypeInfo type) {
        int index = type.getApexName().indexOf(60);
        return index >= 0 ? type.getApexName().substring(0, index) : type.getApexName();
    }

    public static String erasedBytecodeName(TypeInfo type) {
        String name;
        String string = name = type != null ? TO_UNPARAMETERIZED_BYTECODE_NAME.apply(type) : "";
        assert (!name.contains("$$"));
        return name;
    }

    static String[] erasedBytecodeNames(TypeInfo ... types) {
        return TypeNameUtil.erasedBytecodeNames(Arrays.asList(types));
    }

    public static String[] erasedBytecodeNames(Collection<TypeInfo> types) {
        List<String> names = types.stream().map(TO_UNPARAMETERIZED_BYTECODE_NAME).sorted().collect(MoreIterables.toUnmodifiableList(types.size()));
        assert (MoreIterables.ensureNone(names, CHECK_GENERIC));
        return names.toArray(new String[names.size()]);
    }

    public static String toInnerTypeLower(String enclosingTypeName, String innerTypeName) {
        if (Strings.isNullOrEmpty(enclosingTypeName)) {
            throw new IllegalArgumentException("enclosingTypeName is null or empty");
        }
        if (Strings.isNullOrEmpty(innerTypeName)) {
            throw new IllegalArgumentException("innerTypeName is null or empty");
        }
        return MyInterner.intern((enclosingTypeName + "$" + innerTypeName).toLowerCase());
    }

    public static String toNamespace(Namespace namespace, String typeName) {
        if (Strings.isNullOrEmpty(typeName)) {
            throw new IllegalArgumentException("typeName is null or empty");
        }
        return MyInterner.intern(Namespace.isEmptyOrNull(namespace) ? typeName : (namespace.toString() + "/" + typeName).toLowerCase());
    }

    public static String toNamespaceLower(Namespace namespace, String typeName) {
        return MyInterner.intern(TypeNameUtil.toNamespace(namespace, typeName).toLowerCase());
    }

    public static String toNamespace(String namespace, String typeName) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("namespace is null or empty");
        }
        if (Strings.isNullOrEmpty(typeName)) {
            throw new IllegalArgumentException("typeName is null or empty");
        }
        return MyInterner.intern(namespace + "/" + typeName);
    }

    public static String toNamespaceLower(String namespace, String typeName) {
        return MyInterner.intern(TypeNameUtil.toNamespace(namespace, typeName).toLowerCase());
    }

    public static boolean isApexBaseException(String typeName) {
        return APEX_BASE_EXCEPTION.matcher(typeName).matches();
    }

    public static boolean isException(String name) {
        return EXCEPTION.matcher(name).matches();
    }
}

