/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.symbol.type.naming.TypeNameParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TypeNameParserTest {
    @DataProvider
    Object[][] bytecodeNameData() {
        return new Object[][]{{"foo", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0])}, {"foo_123.", new TypeNameParser.TypeName("foo_123.", new TypeNameParser.TypeName[0])}, {"foo$$lbar$$r", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName[0]))}, {"foo$$lbar$$cbaz$$r", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName[0]), new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0]))}, {"foo$$lbar$$lbaz$$r$$r", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0])))}, {"foo$$lbar$$lbaz$$cfoo$$r$$cfoo$$r", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0]), new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0])), new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0]))}};
    }

    @Test(dataProvider="bytecodeNameData")
    public void testBytecodeName(String input, TypeNameParser.TypeName expected) {
        MatcherAssert.assertThat((Object)TypeNameParser.parseBytecodeName(input), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] apexNameData() {
        return new Object[][]{{"foo", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0])}, {"foo_123.", new TypeNameParser.TypeName("foo_123.", new TypeNameParser.TypeName[0])}, {"foo<bar>", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName[0]))}, {"foo<bar,baz>", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName[0]), new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0]))}, {"foo<bar<baz>>", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0])))}, {"foo<bar<baz,foo>,foo>", new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName("bar", new TypeNameParser.TypeName("baz", new TypeNameParser.TypeName[0]), new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0])), new TypeNameParser.TypeName("foo", new TypeNameParser.TypeName[0]))}};
    }

    @Test(dataProvider="apexNameData")
    public void testApexName(String input, TypeNameParser.TypeName expected) {
        MatcherAssert.assertThat((Object)TypeNameParser.parseApexName(input), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testInfoBytecodeName() {
        TypeNameParser.TypeName value = TypeNameParser.parseBytecodeName("prefix/namespace/outer$foo");
        MatcherAssert.assertThat((Object)value.info.namespace, (Matcher)Is.is((Object)"namespace"));
        MatcherAssert.assertThat((Object)value.info.enclosingName, (Matcher)Is.is((Object)"outer"));
        MatcherAssert.assertThat((Object)value.info.className, (Matcher)Is.is((Object)"foo"));
        MatcherAssert.assertThat((Object)value.info.getTopLevelName(), (Matcher)Is.is((Object)"outer"));
    }

    @Test
    public void testSimpleInfoBytecodeName() {
        TypeNameParser.TypeName value = TypeNameParser.parseBytecodeName("foo");
        MatcherAssert.assertThat((Object)value.info.namespace, (Matcher)Matchers.emptyString());
        MatcherAssert.assertThat((Object)value.info.enclosingName, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)value.info.className, (Matcher)Is.is((Object)"foo"));
        MatcherAssert.assertThat((Object)value.info.getTopLevelName(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testInfoApexName() {
        TypeNameParser.TypeName value = TypeNameParser.parseApexName("namespace.outer.foo");
        MatcherAssert.assertThat((Object)value.info.namespace, (Matcher)Is.is((Object)"namespace"));
        MatcherAssert.assertThat((Object)value.info.enclosingName, (Matcher)Is.is((Object)"outer"));
        MatcherAssert.assertThat((Object)value.info.className, (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testInfoApexNameNonDeterministic() {
        TypeNameParser.TypeName value = TypeNameParser.parseApexName("namespace.foo");
        MatcherAssert.assertThat((Object)value.info.namespace, (Matcher)Is.is((Object)"namespace"));
        MatcherAssert.assertThat((Object)value.info.enclosingName, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)value.info.className, (Matcher)Is.is((Object)"foo"));
    }
}

