/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.base.Strings;

public class TypeNameFactory {
    public static final String TRIGGER_PREFIX = "__sfdc_trigger/";
    public static final String ANONYMOUS_BLOCK_NAME = "anon";
    private static final String NO_PREFIX = "";

    private TypeNameFactory() {
    }

    public static Pair<String, String> create(final SourceFile sourceFile, final TypeInfo enclosingType, CompilationUnit typeRef) {
        assert (enclosingType == null || sourceFile.getNamespace().equals(enclosingType.getNamespace())) : "namespace mismatch";
        return typeRef.match(new CompilationUnit.MatchBlock<Pair<String, String>>(){

            @Override
            public Pair<String, String> _case(CompilationUnit.TriggerDeclUnit x) {
                assert (enclosingType == null) : "triggers cannot be an inner type";
                return TypeNameFactory.create(sourceFile, enclosingType, x.name.value, TypeNameFactory.TRIGGER_PREFIX);
            }

            @Override
            public Pair<String, String> _case(CompilationUnit.AnonymousBlockUnit ab) {
                assert (enclosingType == null) : "anonymous cannot be an inner type";
                return new Pair<String, String>(TypeNameFactory.ANONYMOUS_BLOCK_NAME, TypeNameFactory.ANONYMOUS_BLOCK_NAME);
            }

            @Override
            public Pair<String, String> _case(CompilationUnit.EnumDeclUnit x) {
                return TypeNameFactory.create(sourceFile, enclosingType, x.body.name.value, TypeNameFactory.NO_PREFIX);
            }

            @Override
            public Pair<String, String> _case(CompilationUnit.ClassDeclUnit x) {
                return TypeNameFactory.create(sourceFile, enclosingType, x.body.name.value, TypeNameFactory.NO_PREFIX);
            }

            @Override
            public Pair<String, String> _case(CompilationUnit.InterfaceDeclUnit x) {
                return TypeNameFactory.create(sourceFile, enclosingType, x.body.name.value, TypeNameFactory.NO_PREFIX);
            }

            @Override
            public Pair<String, String> _case(CompilationUnit.InvalidDeclUnit x) {
                throw new UnexpectedCodePathException();
            }
        });
    }

    private static Pair<String, String> create(SourceFile sourceFile, TypeInfo enclosingType, String name, String unitPrefix) {
        String apexName = TypeNameFactory.createApexName(sourceFile, enclosingType, name);
        String bytecodeName = TypeNameFactory.createBytecodeName(sourceFile, enclosingType, unitPrefix, name);
        return new Pair<String, String>(apexName, bytecodeName);
    }

    private static String createApexName(SourceFile sourceFile, TypeInfo enclosingType, String className) {
        String prefix = enclosingType == null || enclosingType.getUnitType() == UnitType.ANONYMOUS ? TypeNameFactory.getPrefix(sourceFile, Separator.DOT) : enclosingType.getApexName() + (Object)((Object)Separator.DOT);
        return prefix + className;
    }

    private static String getPrefix(SourceFile sourceFile, Separator separator) {
        Namespace namespace = sourceFile.getNamespace();
        return Namespace.isEmptyOrNull(namespace) ? NO_PREFIX : (namespace.equalsGlobal(Namespaces.FLOW) && !Strings.isNullOrEmpty(namespace.getModule()) ? namespace.getGlobal() + (Object)((Object)separator) + TypeNameFactory.getFlowModuleName(namespace.getModule(), separator.value) + (Object)((Object)separator) : namespace.getGlobal() + (Object)((Object)separator));
    }

    private static String getFlowModuleName(String namespaceModule, String separator) {
        return namespaceModule.replace(Separator.DOT.value, separator);
    }

    private static String createBytecodeName(SourceFile sourceFile, TypeInfo enclosingType, String unitPrefix, String className) {
        assert (enclosingType == null || unitPrefix.isEmpty());
        String prefix = enclosingType == null ? TypeNameFactory.getPrefix(sourceFile, Separator.SLASH) : enclosingType.getBytecodeName() + "$";
        return unitPrefix + prefix + className;
    }

    private static enum Separator {
        SLASH("/"),
        DOT(".");

        private final String value;

        private Separator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

