/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.details;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.details.InterfaceTypeRefsMatcher;
import apex.jorje.semantic.symbol.type.details.NameMatcher;
import apex.jorje.semantic.symbol.type.details.SuperTypeRefMatcher;
import apex.jorje.semantic.symbol.type.details.TriggerTargetTypeMatcher;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;

public interface CodeUnitDetailsProvider {
    public static final Initializer<CodeUnitDetails, TypeInfo> NONE = NonSourceCodeUnitDetails::new;

    public static class NonSourceCodeUnitDetails
    implements CodeUnitDetails {
        private final TypeInfo type;

        public NonSourceCodeUnitDetails(TypeInfo type) {
            this.type = type;
        }

        @Override
        public boolean isApexSourceBased() {
            return false;
        }

        @Override
        public SourceFile getSource() {
            throw new UnsupportedOperationException("Can't get source for non source code unit");
        }

        @Override
        public String getName() {
            return this.type.getApexName();
        }

        @Override
        public boolean isTrusted() {
            return true;
        }

        @Override
        public boolean isFileBased() {
            return false;
        }

        @Override
        public Version getVersion() {
            return Version.CURRENT;
        }

        @Override
        public TypeInfo getType() {
            return this.type;
        }

        @Override
        public TypeReference getTriggerType() {
            throw new UnsupportedOperationException("Can't get Trigger Type for non source code unit");
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            throw new UnsupportedOperationException("Can't get Super Type Ref for non source code unit");
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            throw new UnsupportedOperationException("Can't get Interface Type Refs for non source code unit");
        }

        @Override
        public Loc getLoc() {
            return Loc._SyntheticLoc();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type).toString();
        }
    }

    @SfdcCalled
    public static class RecompiledCodeUnitDetails
    implements CodeUnitDetails {
        private final TypeInfo type;
        private final SourceFile source;

        public RecompiledCodeUnitDetails(TypeInfo type, SourceFile source) {
            this.type = type;
            this.source = source;
        }

        @Override
        public boolean isApexSourceBased() {
            return true;
        }

        @Override
        public SourceFile getSource() {
            return this.source;
        }

        @Override
        public String getName() {
            return this.type.getApexName();
        }

        @Override
        public boolean isTrusted() {
            return this.source.isTrusted();
        }

        @Override
        public boolean isFileBased() {
            return this.source.isFileBased();
        }

        @Override
        public Version getVersion() {
            return this.source.getVersion();
        }

        @Override
        public TypeInfo getType() {
            return this.type;
        }

        @Override
        public TypeReference getTriggerType() {
            throw new UnsupportedOperationException("Can't get Trigger Type for recompiled code unit");
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            throw new UnsupportedOperationException("Can't get Super Type Ref for recompiled code unit");
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            throw new UnsupportedOperationException("Can't get Interface Type Refs for recompiled code unit");
        }

        @Override
        public Loc getLoc() {
            return Loc._SyntheticLoc();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type).toString();
        }
    }

    public static class SourceCodeUnitDetails
    implements CodeUnitDetails {
        private final TypeInfo type;
        private final SourceFile source;
        private final String name;
        private final TypeReference triggerType;
        private final Optional<TypeRef> superTypeRef;
        private final List<TypeRef> interfaceTypeRefs;
        private final Loc loc;

        public SourceCodeUnitDetails(TypeInfo type, SourceFile source, CompilationUnit compilationUnit) {
            this.type = type;
            this.source = source;
            this.name = compilationUnit.match(new NameMatcher());
            this.triggerType = compilationUnit.match(new TriggerTargetTypeMatcher());
            this.superTypeRef = compilationUnit.match(new SuperTypeRefMatcher());
            this.interfaceTypeRefs = compilationUnit.match(new InterfaceTypeRefsMatcher());
            this.loc = Location.from(compilationUnit);
        }

        @Override
        public boolean isApexSourceBased() {
            return true;
        }

        @Override
        public Loc getLoc() {
            return this.loc;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type).toString();
        }

        @Override
        public boolean isTrusted() {
            return this.source.isTrusted();
        }

        @Override
        public SourceFile getSource() {
            return this.source;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFileBased() {
            return this.source.isFileBased();
        }

        @Override
        public Version getVersion() {
            return this.source.getVersion();
        }

        @Override
        public TypeInfo getType() {
            return this.type;
        }

        @Override
        public TypeReference getTriggerType() {
            return this.triggerType;
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            return this.superTypeRef;
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            return this.interfaceTypeRefs;
        }
    }
}

