/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SObjectTypeInfoUtilTest {
    @DataProvider
    Object[][] isSObjectListData() {
        return new Object[][]{{TypeInfos.INTEGER, false}, {ReifiedTypeInfos.STRING_SET, false}, {ReifiedTypeInfos.STRING_LIST, false}, {ReifiedTypeInfos.SOBJECT_LIST, true}};
    }

    @Test(dataProvider="isSObjectListData")
    public void testIsSObjectList(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)SObjectTypeInfoUtil.isSObjectList(type), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] isConcreteSObjectData() {
        return new Object[][]{{TypeInfos.INTEGER, false}, {TypeInfos.SOBJECT, false}, {InternalTypeInfos.SOBJECT_USER, true}};
    }

    @Test(dataProvider="isConcreteSObjectData")
    public void testIsConcreteSObject(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)SObjectTypeInfoUtil.isConcreteSObject(type), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] isGenericSObjectListData() {
        return new Object[][]{{TypeInfos.INTEGER, false}, {ReifiedTypeInfos.STRING_SET, false}, {ReifiedTypeInfos.STRING_LIST, false}, {ReifiedTypeInfos.SOBJECT_LIST, true}, {GenericTypeInfoFactory.createList(InternalTypeInfos.SOBJECT_USER), false}};
    }

    @Test(dataProvider="isGenericSObjectListData")
    public void testIsGenericSObjectListData(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)SObjectTypeInfoUtil.isGenericSObjectList(type), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] isConcreteSObjectListData() {
        return new Object[][]{{TypeInfos.INTEGER, false}, {ReifiedTypeInfos.STRING_SET, false}, {ReifiedTypeInfos.STRING_LIST, false}, {ReifiedTypeInfos.SOBJECT_LIST, false}, {GenericTypeInfoFactory.createList(InternalTypeInfos.SOBJECT_USER), true}};
    }

    @Test(dataProvider="isConcreteSObjectListData")
    public void testIsConcreteSObjectList(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)SObjectTypeInfoUtil.isConcreteSObjectList(type), (Matcher)Matchers.is((Object)expected));
    }
}

