/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;

public class SObjectTypeInfoUtil {
    private SObjectTypeInfoUtil() {
    }

    public static boolean isSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && CollectionTypeInfoUtil.getElementType(type).getBasicType() == BasicType.SOBJECT;
    }

    public static boolean isGenericSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(type), TypeInfos.SOBJECT);
    }

    public static boolean isConcreteSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && SObjectTypeInfoUtil.isConcreteSObject(CollectionTypeInfoUtil.getElementType(type));
    }

    public static boolean isConcreteSObject(TypeInfo type) {
        return type.getBasicType() == BasicType.SOBJECT && !TypeInfoEquivalence.isEquivalent(type, TypeInfos.SOBJECT);
    }

    public static boolean isDmlOperationAllowedStatically(TypeInfo definingType, final DmlOperation dmlOp, TypeInfo type) {
        final boolean isNotTrustedOrInternalTrigger = definingType.getUnitType() != UnitType.TRIGGER || !definingType.getCodeUnitDetails().isTrusted();
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return type.getBasicType() == BasicType.SOBJECT;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                boolean isDmlOperationSupported = dmlOp == DmlOperation.UPSERT || type.getMetadata().getSupportedDml().contains((Object)dmlOp);
                boolean isDmlAllowedOnSetupEntity = SObjectTypeInfoUtil.isDmlAllowedOnSetupEntity(type, dmlOp);
                return (isDmlOperationSupported | !isNotTrustedOrInternalTrigger) & isDmlAllowedOnSetupEntity;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return CollectionTypeInfoUtil.isCollection(type) && CollectionTypeInfoUtil.getElementType(type).accept(this) != false;
            }
        });
    }

    public static boolean isDmlAllowedOnSetupEntity(SObjectTypeInfo type, DmlOperation dmlOp) {
        switch (dmlOp) {
            case INSERT: 
            case UPDATE: {
                return true;
            }
            case MERGE: 
            case UNDELETE: 
            case DELETE: 
            case LEAD_CONVERT: 
            case UPSERT: {
                return !type.getMetadata().isCustomizableSetupEntity();
            }
        }
        return true;
    }

    public static boolean isLookupField(TypeInfo type, final String fieldName) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return type.getBasicType() == BasicType.SOBJECT;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                return type.getMetadata().getIsLookupField().apply(fieldName);
            }
        });
    }

    public static SObjectTypeInfo.MethodsForEmit getMethodsForEmit(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<SObjectTypeInfo.MethodsForEmit>(){

            @Override
            protected SObjectTypeInfo.MethodsForEmit _default(TypeInfo type) {
                throw new UnexpectedCodePathException();
            }

            @Override
            public SObjectTypeInfo.MethodsForEmit visit(ScalarTypeInfo type) {
                if (type.getBasicType() == BasicType.SOBJECT) {
                    return SObjectTypeInfo.getGenericMethodsForEmit();
                }
                throw new UnexpectedCodePathException();
            }

            @Override
            public SObjectTypeInfo.MethodsForEmit visit(SObjectTypeInfo type) {
                return type.getMethodsForEmit();
            }
        });
    }

    public static boolean isQualifiedField(Namespace namespace, String field) {
        return field.startsWith(namespace + "__");
    }
}

