/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.Version;

public class GenericTypeInfoUtil {
    private GenericTypeInfoUtil() {
    }

    public static GenericTypeInfo asGenericType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<GenericTypeInfo>(){

            @Override
            protected GenericTypeInfo _default(TypeInfo type) {
                throw new UnexpectedCodePathException();
            }

            @Override
            public GenericTypeInfo visit(GenericTypeInfo type) {
                return type;
            }
        });
    }

    public static TypeInfo getRootType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(GenericTypeInfo type) {
                return type.getRootUnreifiedType();
            }
        });
    }

    public static boolean isUserGenericInterface(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return !type.getRootUnreifiedType().getCodeUnitDetails().isFileBased() && type.getUnitType() == UnitType.INTERFACE;
            }
        });
    }

    public static boolean isGenericType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return true;
            }
        });
    }

    public static boolean typeParametersAllowed(boolean hasApexParameterizedTypes, CodeUnitDetails codeUnit) {
        return hasApexParameterizedTypes || codeUnit.getType().getUnitType() == UnitType.INTERFACE && (codeUnit.isTrusted() || codeUnit.getVersion().isLessThanOrEqual(Version.V178));
    }

    public static boolean isReifiedType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return true;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                for (TypeInfo argumentType : type.getTypeArguments()) {
                    if (GenericTypeInfoUtil.isReifiedType(argumentType)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Boolean visit(ArgumentTypeInfo type) {
                return false;
            }
        });
    }
}

