/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.collect.Iterables;

public class CollectionTypeInfoUtil {
    private CollectionTypeInfoUtil() {
    }

    public static TypeInfo getElementType(TypeInfo type) {
        return CollectionTypeInfoUtil.getElementType(GenericTypeInfoUtil.asGenericType(type));
    }

    public static TypeInfo getElementType(GenericTypeInfo type) {
        return Iterables.getOnlyElement(type.getTypeArguments());
    }

    public static TypeInfo getKeyType(TypeInfo type) {
        return CollectionTypeInfoUtil.getKeyType(GenericTypeInfoUtil.asGenericType(type));
    }

    public static TypeInfo getKeyType(GenericTypeInfo type) {
        assert (CollectionTypeInfoUtil.isMap(type));
        return type.getTypeArguments().get(0);
    }

    public static TypeInfo getValueType(TypeInfo type) {
        return CollectionTypeInfoUtil.getValueType(GenericTypeInfoUtil.asGenericType(type));
    }

    public static TypeInfo getValueType(GenericTypeInfo type) {
        assert (CollectionTypeInfoUtil.isMap(type));
        return type.getTypeArguments().get(1);
    }

    public static boolean isSet(TypeInfo type) {
        return type.getBasicType() == BasicType.SET;
    }

    public static boolean isList(TypeInfo type) {
        return type.getBasicType() == BasicType.LIST;
    }

    public static boolean isMap(TypeInfo type) {
        return type.getBasicType() == BasicType.MAP;
    }

    public static boolean isCollection(TypeInfo type) {
        return CollectionTypeInfoUtil.isSet(type) || CollectionTypeInfoUtil.isList(type);
    }

    public static boolean isMapOrCollection(TypeInfo type) {
        return CollectionTypeInfoUtil.isCollection(type) || CollectionTypeInfoUtil.isMap(type);
    }
}

