/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VfComponentTypeInfoTest {
    private static final String VF_TYPE_NOT_VISIBLE = I18nSupport.getLabel("type.not.visible", TestVfTypeInfos.OUTPUT_TEXT);
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @Test
    public void testVfComponentName() {
        VfComponentTypeInfo type = (VfComponentTypeInfo)((VfComponentTypeInfo.Builder)((VfComponentTypeInfo.Builder)VfComponentTypeInfo.builder().setVfComponentName("OutputPanel").setNamespace(Namespaces.APEX)).setParents(InternalTypeInfos.APEX_PAGES_COMPONENT)).buildResolved();
        MatcherAssert.assertThat((Object)type.getApexName(), (Matcher)CoreMatchers.is((Object)"Component.Apex.OutputPanel"));
        MatcherAssert.assertThat((Object)type.getBytecodeName(), (Matcher)CoreMatchers.is((Object)"com/salesforce/api/VisualForceComponent/Component/apex/outputpanel"));
    }

    @DataProvider
    Object[][] invalidTriggerData() {
        return new Object[][]{{"trigger foo on account (before insert) { Component.apex.OutputText a; }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { void fooMethod() { Component.apex.OutputText a; } }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { void fooMethod(Component.apex.OutputText a) { } }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { public class innerBar { Component.apex.OutputText a; } }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { public class innerBar { Component.apex.OutputText a {get; set;} } }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { public class innerBar { void method() {Component.apex.OutputText a; } } }", VF_TYPE_NOT_VISIBLE}, {"trigger foo on account (before insert) { public class innerBar { void method(Component.apex.OutputText a) { } } }", VF_TYPE_NOT_VISIBLE}};
    }

    @Test(dataProvider="invalidTriggerData")
    public void testVFComponentsAreNotAllowedInTriggers(String code, String error) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, error);
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"Component.apex.outputtext optext;", VF_TYPE_NOT_VISIBLE}, {"void fooMethod() { Component.apex.outputtext optext; }", VF_TYPE_NOT_VISIBLE}, {"void fooMethod(Component.apex.outputtext optext) { } ", VF_TYPE_NOT_VISIBLE}, {"public class innerBar { Component.apex.outputtext optext; }", VF_TYPE_NOT_VISIBLE}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testVFComponentsAreNotAllowedInAnonymous(String code, String error) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, error);
    }
}

