/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class UnresolvedErrorCalculatorTest {
    private static final TypeInfo UNRESOLVED_FOO = UnresolvedTypeInfoFactory.create("foo");
    private static final TypeInfo FIVE_DEEP_LIST = GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(GenericTypeInfoFactory.createList(TypeInfos.INTEGER)))));
    private static final TypeInfo GENERIC_TYPE_FOO = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T, ArgumentTypeInfos.U).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).buildResolved();

    @DataProvider
    Object[][] unresolvedErrors() {
        return new Object[][]{{UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, FIVE_DEEP_LIST), ImmutableList.of(I18nSupport.getLabel("parameterized.type.too.deep", GenericTypeInfoFactory.createList(FIVE_DEEP_LIST), 6))}, {UNRESOLVED_FOO, ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", "foo"))}, {UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, new TypeInfo[0]), ImmutableList.of(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", TypeInfos.LIST))}, {UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.STRING, TypeInfos.STRING), ImmutableList.of(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeInfos.STRING))}, {UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, TypeInfos.STRING, TypeInfos.STRING), ImmutableList.of(I18nSupport.getLabel("invalid.parameterized.type.count", TypeInfos.LIST, 1, 2))}, {UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, UNRESOLVED_FOO), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", "foo"))}, {UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, UNRESOLVED_FOO)), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", "foo"))}, {UnresolvedTypeInfoFactory.create(GENERIC_TYPE_FOO, TypeInfos.STRING, UNRESOLVED_FOO), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", "foo"))}};
    }

    @Test(dataProvider="unresolvedErrors")
    public void testUnresolvedErrors(TypeInfo type, List<String> errors) {
        MatcherAssert.assertThat(UnresolvedErrorCalculator.getErrors(type), (Matcher)Matchers.is(errors));
    }

    @Test
    public void testTypeParameterUnresolvedUserType() {
        ValidationTester tester = new ValidationTester();
        tester.setParserType(ParserWrapper.Type.NAMED);
        tester.setVersion(Version.V176);
        tester.assertFailure(ImmutableList.of("public interface IFace<T> { }", "public class Foo { public Foo(IFace<NonExistentType> t) { } }"), Collections.singletonList(I18nSupport.getLabel("invalid.unresolved.type", "NonExistentType")));
    }
}

