/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.services.I18nSupport;

public enum UnitType {
    CLASS("class.plural"),
    INTERFACE("interface.plural"),
    ENUM("enum.plural"),
    TRIGGER("trigger.plural"),
    ANNOTATION("annotation.plural"),
    ANONYMOUS("anonymous.plural"),
    UNRESOLVED("unresolved");

    private final String name;
    public static final CompilationUnit.MatchBlock<UnitType> TO_UNIT_TYPE;

    private UnitType(String label) {
        this.name = I18nSupport.getLabel(label);
    }

    public String toString() {
        return this.name;
    }

    static {
        TO_UNIT_TYPE = new CompilationUnit.MatchBlock<UnitType>(){

            @Override
            public UnitType _case(CompilationUnit.TriggerDeclUnit x) {
                return TRIGGER;
            }

            @Override
            public UnitType _case(CompilationUnit.AnonymousBlockUnit x) {
                return ANONYMOUS;
            }

            @Override
            public UnitType _case(CompilationUnit.EnumDeclUnit x) {
                return ENUM;
            }

            @Override
            public UnitType _case(CompilationUnit.ClassDeclUnit x) {
                return CLASS;
            }

            @Override
            public UnitType _case(CompilationUnit.InterfaceDeclUnit x) {
                return INTERFACE;
            }

            @Override
            public UnitType _case(CompilationUnit.InvalidDeclUnit x) {
                throw new UnexpectedCodePathException();
            }
        };
    }
}

