/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.SymbolInfoSerializer;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class TypeInfoTest {
    private static final String INTEGER_BASELINE = "ApexName: Integer\nNamespace: \nSuperType: null\nMethod: global String format()\nMethod: global static Integer valueOf(Object)\nMethod: global static Integer valueOf(String)\nMethod: global static String format(Integer)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String LONG_BASELINE = "ApexName: Long\nNamespace: \nSuperType: null\nMethod: global Integer intValue()\nMethod: global String format()\nMethod: global static Integer intValue(Long)\nMethod: global static Long valueOf(String)\nMethod: global static String format(Long)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)";
    private static final String DOUBLE_BASELINE = "ApexName: Double\nNamespace: \nSuperType: null\nMethod: global Integer intValue()\nMethod: global Long longValue()\nMethod: global Long round()\nMethod: global String format()\nMethod: global static Double valueOf(Object)\nMethod: global static Double valueOf(String)\nMethod: global static Integer intValue(Double)\nMethod: global static Long longValue(Double)\nMethod: global static Long round(Double)\nMethod: global static String format(Double)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)";
    private static final String DECIMAL_BASELINE = "ApexName: Decimal\nNamespace: \nSuperType: null\nMethod: global Decimal abs()\nMethod: global Decimal add(Decimal)\nMethod: global Decimal divide(Decimal)\nMethod: global Decimal divide(Decimal, Integer)\nMethod: global Decimal divide(Decimal, Integer, Object)\nMethod: global Decimal multiply(Decimal)\nMethod: global Decimal negate()\nMethod: global Decimal pow(Integer)\nMethod: global Decimal setScale(Integer)\nMethod: global Decimal setScale(Integer, System.RoundingMode)\nMethod: global Decimal stripTrailingZeros()\nMethod: global Decimal subtract(Decimal)\nMethod: global Double doubleValue()\nMethod: global Integer compareTo(Decimal)\nMethod: global Integer intValue()\nMethod: global Integer precision()\nMethod: global Integer scale()\nMethod: global Long longValue()\nMethod: global Long round()\nMethod: global Long round(System.RoundingMode)\nMethod: global String format()\nMethod: global String toPlainString()\nMethod: global static Decimal valueOf(Double)\nMethod: global static Decimal valueOf(Long)\nMethod: global static Decimal valueOf(String)\nMethod: global static Decimal valueOfBytecode(String)\nMethod: global static Decimal valueOfNullOk(Double)\nMethod: global static Decimal valueOfNullOk(Long)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String TIME_BASELINE = "ApexName: Time\nNamespace: \nSuperType: null\nMethod: global Integer compareTo(Time)\nMethod: global Integer hour()\nMethod: global Integer millisecond()\nMethod: global Integer minute()\nMethod: global Integer second()\nMethod: global Time addHours(Integer)\nMethod: global Time addMilliseconds(Integer)\nMethod: global Time addMinutes(Integer)\nMethod: global Time addSeconds(Integer)\nMethod: global static Time newInstance(Integer, Integer, Integer, Integer)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)";
    private static final String DATE_BASELINE = "ApexName: Date\nNamespace: \nSuperType: null\nMethod: global Boolean isSameDay(Date)\nMethod: global Date addDays(Integer)\nMethod: global Date addMonths(Integer)\nMethod: global Date addYears(Integer)\nMethod: global Date toStartOfMonth()\nMethod: global Date toStartOfWeek()\nMethod: global Integer compareTo(Date)\nMethod: global Integer day()\nMethod: global Integer dayOfYear()\nMethod: global Integer daysBetween(Date)\nMethod: global Integer month()\nMethod: global Integer monthsBetween(Date)\nMethod: global Integer year()\nMethod: global String format()\nMethod: global static Boolean isLeapYear(Integer)\nMethod: global static Date newInstance(Integer, Integer, Integer)\nMethod: global static Date parse(String)\nMethod: global static Date today()\nMethod: global static Date today(String)\nMethod: global static Date todayTz(String)\nMethod: global static Date valueOf(Object)\nMethod: global static Date valueOf(String)\nMethod: global static Double getTimeZoneOffset(String)\nMethod: global static Integer daysInMonth(Integer, Integer)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String DATE_TIME_BASELINE = "ApexName: Datetime\nNamespace: \nSuperType: null\nMethod: global Boolean isSameDay(Datetime)\nMethod: global Date date()\nMethod: global Date dateGmt()\nMethod: global Datetime addDays(Double)\nMethod: global Datetime addDays(Integer)\nMethod: global Datetime addHours(Integer)\nMethod: global Datetime addMinutes(Integer)\nMethod: global Datetime addMonths(Integer)\nMethod: global Datetime addSeconds(Integer)\nMethod: global Datetime addYears(Integer)\nMethod: global Integer compareTo(Datetime)\nMethod: global Integer day()\nMethod: global Integer dayGmt()\nMethod: global Integer dayOfYear()\nMethod: global Integer dayOfYearGmt()\nMethod: global Integer hour()\nMethod: global Integer hourGmt()\nMethod: global Integer millisecond()\nMethod: global Integer millisecondGmt()\nMethod: global Integer minute()\nMethod: global Integer minuteGmt()\nMethod: global Integer month()\nMethod: global Integer monthGmt()\nMethod: global Integer second()\nMethod: global Integer secondGmt()\nMethod: global Integer year()\nMethod: global Integer yearGmt()\nMethod: global Long getTime()\nMethod: global String format()\nMethod: global String format(String)\nMethod: global String format(String, String)\nMethod: global String formatGmt(String)\nMethod: global String formatLong()\nMethod: global Time time()\nMethod: global Time timeGmt()\nMethod: global static Datetime newInstance(Date)\nMethod: global static Datetime newInstance(Date, Time)\nMethod: global static Datetime newInstance(Integer, Integer, Integer)\nMethod: global static Datetime newInstance(Integer, Integer, Integer, Integer, Integer, Integer)\nMethod: global static Datetime newInstance(Long)\nMethod: global static Datetime newInstanceGmt(Date, Time)\nMethod: global static Datetime newInstanceGmt(Integer, Integer, Integer)\nMethod: global static Datetime newInstanceGmt(Integer, Integer, Integer, Integer, Integer, Integer)\nMethod: global static Datetime now()\nMethod: global static Datetime parse(String)\nMethod: global static Datetime valueOf(Object)\nMethod: global static Datetime valueOf(String)\nMethod: global static Datetime valueOfGmt(String)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String BOOLEAN_BASELINE = "ApexName: Boolean\nNamespace: \nSuperType: null\nMethod: global static Boolean valueOf(Object)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)";
    private static final String STRING_BASELINE = "ApexName: String\nNamespace: \nSuperType: null\nMethod: global Boolean contains(String)\nMethod: global Boolean containsAny(String)\nMethod: global Boolean containsIgnoreCase(String)\nMethod: global Boolean containsNone(String)\nMethod: global Boolean containsOnly(String)\nMethod: global Boolean containsWhitespace()\nMethod: global Boolean endsWith(String)\nMethod: global Boolean endsWithIgnoreCase(String)\nMethod: global Boolean equals(Object)\nMethod: global Boolean equalsIgnoreCase(String)\nMethod: global Boolean isAllLowerCase()\nMethod: global Boolean isAllUpperCase()\nMethod: global Boolean isAlpha()\nMethod: global Boolean isAlphaSpace()\nMethod: global Boolean isAlphanumeric()\nMethod: global Boolean isAlphanumericSpace()\nMethod: global Boolean isAsciiPrintable()\nMethod: global Boolean isNumeric()\nMethod: global Boolean isNumericSpace()\nMethod: global Boolean isWhitespace()\nMethod: global Boolean startsWith(String)\nMethod: global Boolean startsWithIgnoreCase(String)\nMethod: global Integer charAt(Integer)\nMethod: global Integer codePointAt(Integer)\nMethod: global Integer codePointBefore(Integer)\nMethod: global Integer codePointCount(Integer, Integer)\nMethod: global Integer compareTo(String)\nMethod: global Integer countMatches(String)\nMethod: global Integer getLevenshteinDistance(String)\nMethod: global Integer getLevenshteinDistance(String, Integer)\nMethod: global Integer hashCode()\nMethod: global Integer indexOf(String)\nMethod: global Integer indexOf(String, Integer)\nMethod: global Integer indexOfAny(String)\nMethod: global Integer indexOfAnyBut(String)\nMethod: global Integer indexOfChar(Integer)\nMethod: global Integer indexOfChar(Integer, Integer)\nMethod: global Integer indexOfDifference(String)\nMethod: global Integer indexOfIgnoreCase(String)\nMethod: global Integer indexOfIgnoreCase(String, Integer)\nMethod: global Integer lastIndexOf(String)\nMethod: global Integer lastIndexOf(String, Integer)\nMethod: global Integer lastIndexOfChar(Integer)\nMethod: global Integer lastIndexOfChar(Integer, Integer)\nMethod: global Integer lastIndexOfIgnoreCase(String)\nMethod: global Integer lastIndexOfIgnoreCase(String, Integer)\nMethod: global Integer length()\nMethod: global Integer offsetByCodePoints(Integer, Integer)\nMethod: global List<Integer> getChars()\nMethod: global List<String> split(String)\nMethod: global List<String> split(String, Integer)\nMethod: global List<String> splitByCharacterType()\nMethod: global List<String> splitByCharacterTypeCamelCase()\nMethod: global String abbreviate(Integer)\nMethod: global String abbreviate(Integer, Integer)\nMethod: global String capitalize()\nMethod: global String center(Integer)\nMethod: global String center(Integer, String)\nMethod: global String deleteWhitespace()\nMethod: global String difference(String)\nMethod: global String escapeCsv()\nMethod: global String escapeEcmaScript()\nMethod: global String escapeHtml3()\nMethod: global String escapeHtml4()\nMethod: global String escapeJava()\nMethod: global String escapeUnicode()\nMethod: global String escapeXml()\nMethod: global String left(Integer)\nMethod: global String leftPad(Integer)\nMethod: global String leftPad(Integer, String)\nMethod: global String mid(Integer, Integer)\nMethod: global String normalizeSpace()\nMethod: global String overlay(String, Integer, Integer)\nMethod: global String remove(String)\nMethod: global String removeEnd(String)\nMethod: global String removeEndIgnoreCase(String)\nMethod: global String removeStart(String)\nMethod: global String removeStartIgnoreCase(String)\nMethod: global String repeat(Integer)\nMethod: global String repeat(String, Integer)\nMethod: global String replace(String, String)\nMethod: global String replaceAll(String, String)\nMethod: global String replaceFirst(String, String)\nMethod: global String reverse()\nMethod: global String right(Integer)\nMethod: global String rightPad(Integer)\nMethod: global String rightPad(Integer, String)\nMethod: global String stringValue()\nMethod: global String stripHtmlTags()\nMethod: global String substring(Integer)\nMethod: global String substring(Integer, Integer)\nMethod: global String substringAfter(String)\nMethod: global String substringAfterLast(String)\nMethod: global String substringBefore(String)\nMethod: global String substringBeforeLast(String)\nMethod: global String substringBetween(String)\nMethod: global String substringBetween(String, String)\nMethod: global String swapCase()\nMethod: global String toLowerCase()\nMethod: global String toLowerCase(String)\nMethod: global String toUpperCase()\nMethod: global String toUpperCase(String)\nMethod: global String trim()\nMethod: global String uncapitalize()\nMethod: global String unescapeCsv()\nMethod: global String unescapeEcmaScript()\nMethod: global String unescapeHtml3()\nMethod: global String unescapeHtml4()\nMethod: global String unescapeJava()\nMethod: global String unescapeUnicode()\nMethod: global String unescapeXml()\nMethod: global static Boolean isBlank(String)\nMethod: global static Boolean isEmpty(String)\nMethod: global static Boolean isNotBlank(String)\nMethod: global static Boolean isNotEmpty(String)\nMethod: global static String append(String, String)\nMethod: global static String escapeSingleQuotes(String)\nMethod: global static String format(String, List<String>)\nMethod: global static String fromCharArray(List<Integer>)\nMethod: global static String getCommonPrefix(List<String>)\nMethod: global static String join(System.Iterable, String)\nMethod: global static String valueOf(Date)\nMethod: global static String valueOf(Datetime)\nMethod: global static String valueOf(Decimal)\nMethod: global static String valueOf(Double)\nMethod: global static String valueOf(Integer)\nMethod: global static String valueOf(Long)\nMethod: global static String valueOf(Object)\nMethod: global static String valueOfGmt(Datetime)\nMethod: global static String valueOfId(Id)\nMethod: global static String valueOfString(String)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String ID_BASELINE = "ApexName: Id\nNamespace: \nSuperType: null\nMethod: global Boolean equals(String)\nMethod: global Integer compareTo(Id, Boolean)\nMethod: global Schema.SObjectType getSobjectType()\nMethod: global static Id valueOf(String)\nMethod: global static Id valueOfNullOk(String)\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\n";
    private static final String BLOB_BASELINE = "ApexName: Blob\nNamespace: \nSuperType: null\nMethod: global Integer size()\nMethod: global String toString()\nMethod: global static Blob toPdf(String)\nMethod: global static Blob valueOf(String)\n";
    private static final String CURRENCY_BASELINE = "ApexName: CURRENCY\nNamespace: \nSuperType: null\nMethod: global String format()\nMethod: global String formatAmount()\nMethod: global static CURRENCY newInstance(Decimal, String)\nMethod: global static Decimal parse(String)\n";
    private static final String VOID_BASELINE = "ApexName: void\nNamespace: \nSuperType: null";
    private static final String SOBJECT_BASELINE = "ApexName: SObject\nNamespace: \nSuperType: null\nMethod: global Boolean isClone()\nMethod: global Database.DMLOptions getOptions()\nMethod: global Id getCloneSourceId()\nMethod: global List<SObject> getSObjects(Schema.SObjectField)\nMethod: global List<SObject> getSObjects(String)\nMethod: global Map<Id, String> getActiveRecordTypes()\nMethod: global Map<String, Id> getActiveRecordTypesByName()\nMethod: global Object get(Schema.SObjectField)\nMethod: global Object get(String)\nMethod: global Object put(Schema.SObjectField, Object)\nMethod: global Object put(String, Object)\nMethod: global SObject clone()\nMethod: global SObject clone(Boolean)\nMethod: global SObject clone(Boolean, Boolean)\nMethod: global SObject clone(Boolean, Boolean, Boolean)\nMethod: global SObject clone(Boolean, Boolean, Boolean, Boolean)\nMethod: global SObject getSObject(Schema.SObjectField)\nMethod: global SObject getSObject(String)\nMethod: global SObject getSObjectsSelectLoop(Object)\nMethod: global SObject getSObjectsSelectLoop(String)\nMethod: global SObject putSObject(Schema.SObjectField, SObject)\nMethod: global SObject putSObject(String, SObject)\nMethod: global Schema.SObjectType getSObjectType()\nMethod: global Set<String> getDifferingFields(SObject)\nMethod: global String getQuickActionName()\nMethod: global void addError(Exception)\nMethod: global void addError(Exception, Boolean)\nMethod: global void addError(String)\nMethod: global void addError(String, Boolean)\nMethod: global void addError(String, String)\nMethod: global void addError(String, String, Boolean)\nMethod: global void clear()\nMethod: global void recalculateFormulas()\nMethod: global void setOptions(Database.DMLOptions)\nField: global Id Id";
    private static final String LIST_BASELINE = "ApexName: List\nNamespace: \nSuperType: null\nInterface: System.Iterable\nMethod: global Boolean equals(Object)\nMethod: global Boolean isEmpty()\nMethod: global Integer hashCode()\nMethod: global Integer size()\nMethod: global List clone()\nMethod: global List deepClone()\nMethod: global List deepClone(Boolean)\nMethod: global List deepClone(Boolean, Boolean)\nMethod: global List deepClone(Boolean, Boolean, Boolean)\nMethod: global Object add(t)\nMethod: global Object chunkIterator(Boolean)\nMethod: global SObject getFirstSObjectBytecode(String)\nMethod: global Schema.SObjectType getSObjectType()\nMethod: global System.ListIterator iterator()\nMethod: global t get(Integer)\nMethod: global t getBytecode(Integer)\nMethod: global t remove(Integer)\nMethod: global void add(Integer, t)\nMethod: global void addAll(List)\nMethod: global void addAll(Set)\nMethod: global void clear()\nMethod: global void readonly()\nMethod: global void set(Integer, t)\nMethod: global void setBytecode(Integer, t)\nMethod: global void sort()";
    private static final String SET_BASELINE = "ApexName: Set\nNamespace: \nSuperType: null\nMethod: global Boolean add(t)\nMethod: global Boolean addAll(List)\nMethod: global Boolean addAll(Set)\nMethod: global Boolean contains(t)\nMethod: global Boolean containsAll(List)\nMethod: global Boolean containsAll(Set)\nMethod: global Boolean equals(Object)\nMethod: global Boolean isEmpty()\nMethod: global Boolean remove(t)\nMethod: global Boolean removeAll(List)\nMethod: global Boolean removeAll(Set)\nMethod: global Boolean retainAll(List)\nMethod: global Boolean retainAll(Set)\nMethod: global Integer hashCode()\nMethod: global Integer size()\nMethod: global Set clone()\nMethod: global System.ListIterator iterator()\nMethod: global void clear()";
    private static final String MAP_BASELINE = "ApexName: Map\nNamespace: \nSuperType: null\nMethod: global Boolean containsKey(k)\nMethod: global Boolean equals(Object)\nMethod: global Boolean isEmpty()\nMethod: global Id getId(k)\nMethod: global Integer hashCode()\nMethod: global Integer size()\nMethod: global List values()\nMethod: global Map clone()\nMethod: global Map deepClone()\nMethod: global Object entrySet()\nMethod: global Schema.SObjectType getSObjectType()\nMethod: global Set keySet()\nMethod: global v get(k)\nMethod: global v put(k, v)\nMethod: global v putBytecode(k, v)\nMethod: global v remove(k)\nMethod: global void clear()\nMethod: global void putAll(List<SObject>)\nMethod: global void putAll(Map)";

    @Test
    public void testInteger() {
        ScalarTypeInfo typeInfo = TypeInfos.INTEGER;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)INTEGER_BASELINE.split("\n")));
    }

    @Test
    public void testLong() {
        ScalarTypeInfo typeInfo = TypeInfos.LONG;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)LONG_BASELINE.split("\n")));
    }

    @Test
    public void testDouble() {
        ScalarTypeInfo typeInfo = TypeInfos.DOUBLE;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)DOUBLE_BASELINE.split("\n")));
    }

    @Test
    public void testDecimal() {
        ScalarTypeInfo typeInfo = TypeInfos.DECIMAL;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)DECIMAL_BASELINE.split("\n")));
    }

    @Test
    public void testTime() {
        ScalarTypeInfo typeInfo = TypeInfos.TIME;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)TIME_BASELINE.split("\n")));
    }

    @Test
    public void testDate() {
        ScalarTypeInfo typeInfo = TypeInfos.DATE;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)DATE_BASELINE.split("\n")));
    }

    @Test
    public void testDateTime() {
        ScalarTypeInfo typeInfo = TypeInfos.DATE_TIME;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)DATE_TIME_BASELINE.split("\n")));
    }

    @Test
    public void testBoolean() {
        ScalarTypeInfo typeInfo = TypeInfos.BOOLEAN;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)BOOLEAN_BASELINE.split("\n")));
    }

    @Test
    public void testString() {
        ScalarTypeInfo typeInfo = TypeInfos.STRING;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)STRING_BASELINE.split("\n")));
    }

    @Test
    public void testId() {
        ScalarTypeInfo typeInfo = TypeInfos.ID;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)ID_BASELINE.split("\n")));
    }

    @Test
    public void testBlob() {
        ScalarTypeInfo typeInfo = TypeInfos.BLOB;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)BLOB_BASELINE.split("\n")));
    }

    @Test
    public void testCurrency() {
        ScalarTypeInfo typeInfo = TypeInfos.CURRENCY;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)CURRENCY_BASELINE.split("\n")));
    }

    @Test
    public void testVoid() {
        ScalarTypeInfo typeInfo = TypeInfos.VOID;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)VOID_BASELINE.split("\n")));
    }

    @Test
    public void testSObject() {
        ScalarTypeInfo typeInfo = TypeInfos.SOBJECT;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)SOBJECT_BASELINE.split("\n")));
    }

    @Test
    public void testList() {
        GenericTypeInfo typeInfo = TypeInfos.LIST;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)LIST_BASELINE.split("\n")));
    }

    @Test
    public void testSet() {
        GenericTypeInfo typeInfo = TypeInfos.SET;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)SET_BASELINE.split("\n")));
    }

    @Test
    public void testMap() {
        GenericTypeInfo typeInfo = TypeInfos.MAP;
        String str = SymbolInfoSerializer.serialize(typeInfo);
        MatcherAssert.assertThat((Object)str.split("\n"), (Matcher)Matchers.is((Object)MAP_BASELINE.split("\n")));
    }
}

