/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectMetadata;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class SObjectTypeInfo
extends AbstractTypeInfo {
    private static final ParentTable SHARED_PARENT_TABLE = ParentTableFactory.create(TypeInfos.SOBJECT);
    private static final Supplier<MethodsForEmit> GENERIC_METHODS_FOR_EMIT = Suppliers.memoize(() -> new MethodsForEmit(TypeInfos.SOBJECT));
    private final MethodsForEmit methodsForEmit = new MethodsForEmit(this);
    private final SObjectMetadata metadata;

    private SObjectTypeInfo(Builder builder) {
        super(builder);
        this.metadata = builder.metadata;
    }

    public static MethodsForEmit getGenericMethodsForEmit() {
        return GENERIC_METHODS_FOR_EMIT.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MethodsForEmit getMethodsForEmit() {
        return this.methodsForEmit;
    }

    public SObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String getApexNameSansNamespace() {
        if (this.getNamespace() != null && !Strings.isNullOrEmpty(this.getNamespace().toString())) {
            String namespacePrefix = this.getNamespace().toString() + "_";
            if (this.getApexName().startsWith(namespacePrefix)) {
                return this.getApexName().substring(namespacePrefix.length());
            }
        }
        return this.getApexName();
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class MethodsForEmit {
        private final TypeInfo type;
        private AsmMethod getRegularValue;
        private AsmMethod getValue;
        private AsmMethod getAggregate;
        private AsmMethod getAggregateForSelect;
        private AsmMethod setValue;

        private MethodsForEmit(TypeInfo type) {
            this.type = type;
        }

        public AsmMethod getRegularValueMethod() {
            return this.getRegularValue == null ? (this.getRegularValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getRegularValue").setSignature((TypeInfo)TypeInfos.OBJECT, (TypeInfo)TypeInfos.STRING).build()) : this.getRegularValue;
        }

        public AsmMethod getValueMethod() {
            return this.getValue == null ? (this.getValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getValue").setSignature((TypeInfo)TypeInfos.OBJECT, (TypeInfo)TypeInfos.STRING).build()) : this.getValue;
        }

        public AsmMethod getAggregateMethod() {
            return this.getAggregate == null ? (this.getAggregate = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getAggregate").setSignature((TypeInfo)TypeInfos.OBJECT, TypeInfos.STRING, TypeInfos.STRING).build()) : this.getAggregate;
        }

        public AsmMethod getAggregateForSelectMethod() {
            return this.getAggregateForSelect == null ? (this.getAggregateForSelect = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getAggregateForSelect").setSignature((TypeInfo)InternalTypeInfos.DATABASE_QUERY_LOCATOR, TypeInfos.STRING, TypeInfos.STRING).build()) : this.getAggregateForSelect;
        }

        public AsmMethod setValueMethod() {
            return this.setValue == null ? (this.setValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("setValue").setSignature((TypeInfo)TypeInfos.VOID, TypeInfos.OBJECT, TypeInfos.STRING).build()) : this.setValue;
        }
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, SObjectTypeInfo> {
        private SObjectMetadata metadata;

        private Builder() {
        }

        public Builder setMetadata(SObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public SObjectTypeInfo build() {
            assert (Strings.isNullOrEmpty(this.getNamespace().getNameLower()) || this.getApexName().toLowerCase().startsWith(this.getNamespace().getNameLower()) || this.getApexName().toLowerCase().startsWith("localmodule" + this.getNamespace().getNameLower())) : "name doesn't start with namespace. Namespace - " + this.getNamespace().getNameLower() + ", Apex name - " + this.getApexName();
            this.setParents(SHARED_PARENT_TABLE);
            this.setMethods(SObjectMethods.get());
            this.setUnitType(UnitType.CLASS);
            this.setModifiers(ModifierGroups.GLOBAL_FINAL);
            this.setBytecodeName("com/salesforce/api/entity/" + this.getApexName());
            this.setBasicType(BasicType.SOBJECT);
            return new SObjectTypeInfo(this);
        }
    }
}

