/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.bcl.DmlOperation;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.EnumSet;

public class SObjectMetadata {
    private final EnumSet<DmlOperation> supportedDml;
    private final Predicate<String> isLookupField;
    private final CustomSettingType customSettingType;
    private final boolean isCustomizableSetupEntity;
    private final boolean isEditable;

    private SObjectMetadata(Builder builder) {
        this.supportedDml = builder.supportedDml;
        this.isLookupField = builder.isLookupField;
        this.customSettingType = builder.customSettingType;
        this.isCustomizableSetupEntity = builder.isCustomizableSetupEntity;
        this.isEditable = builder.isEditable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnumSet<DmlOperation> getSupportedDml() {
        return this.supportedDml;
    }

    public Predicate<String> getIsLookupField() {
        return this.isLookupField;
    }

    public boolean isCustomizableSetupEntity() {
        return this.isCustomizableSetupEntity;
    }

    public boolean isCustomSetting() {
        return this.customSettingType != CustomSettingType.NONE;
    }

    public CustomSettingType getCustomSettingType() {
        return this.customSettingType;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public static class Builder {
        private EnumSet<DmlOperation> supportedDml = DmlOperation.ALL;
        private Predicate<String> isLookupField = Predicates.alwaysFalse();
        private CustomSettingType customSettingType = CustomSettingType.NONE;
        private boolean isCustomizableSetupEntity;
        private boolean isEditable = true;

        private Builder() {
        }

        public Builder setSupportedDml(EnumSet<DmlOperation> supportedDml) {
            this.supportedDml = supportedDml;
            return this;
        }

        public Builder setLookupFieldPredicate(Predicate<String> isLookupField) {
            this.isLookupField = isLookupField;
            return this;
        }

        public Builder setCustomSettingType(CustomSettingType customSettingType) {
            this.customSettingType = customSettingType;
            return this;
        }

        public Builder setCustomizableSetupEntity(boolean isCustomizableSetupEntity) {
            this.isCustomizableSetupEntity = isCustomizableSetupEntity;
            return this;
        }

        public Builder setEditable(boolean isEditable) {
            this.isEditable = isEditable;
            return this;
        }

        public SObjectMetadata build() {
            return new SObjectMetadata(this);
        }
    }

    public static enum CustomSettingType {
        LIST,
        HIERARCHY,
        NONE;

    }
}

