/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class ReifiedParentsInitializer
implements Initializer<ParentTable, TypeInfo> {
    @Override
    public ParentTable get(TypeInfo inputType) {
        GenericTypeInfo type = GenericTypeInfoUtil.asGenericType(inputType);
        assert (type.getUnreifiedType() != null) : "using an unreified type for a reified table makes no sense";
        return this.createClonedParents(type, type.getRootUnreifiedType());
    }

    private ParentTable createClonedParents(GenericTypeInfo type, TypeInfo rootUnreifiedType) {
        Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> unparameterizedToParameterized = ArgumentTypeInfoConverter.getResolutionMap(type, rootUnreifiedType);
        TypeInfo superType = rootUnreifiedType.parents().superType() == null ? null : ArgumentTypeInfoConverter.convertType(unparameterizedToParameterized, rootUnreifiedType.parents().superType());
        ImmutableSet.Builder interfaces = ImmutableSet.builder();
        for (TypeInfo interfaceType : rootUnreifiedType.parents().immediateInterfaces()) {
            interfaces.add(ArgumentTypeInfoConverter.convertType(unparameterizedToParameterized, interfaceType));
        }
        return ParentTableFactory.create(superType, (Set<TypeInfo>)((Object)interfaces.build()));
    }
}

