/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ReifiedFieldsInitializer;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReifiedFieldsInitializerTest {
    private static final List<TypeInfo> ARGUMENT_TYPE_INFOS = ImmutableList.of(ArgumentTypeInfos.T);
    private static final List<TypeInfo> TYPES = ImmutableList.of(TypeInfos.INTEGER);
    private FieldTable fields;
    private GenericTypeInfo nonGenericType;
    private GenericTypeInfo genericType;
    private ReifiedFieldsInitializer initializer;

    @BeforeMethod
    public void setUp() {
        this.fields = new StandardFieldTable();
        this.nonGenericType = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ARGUMENT_TYPE_INFOS).setFields(this.fields)).buildResolved();
        this.genericType = GenericTypeInfo.builder().setUnreifiedType(this.nonGenericType).setTypeArguments(TYPES).buildResolved();
        this.initializer = new ReifiedFieldsInitializer();
    }

    private void assertCloneField(FieldInfo newField, FieldInfo originalField, TypeInfo reifiedType) {
        MatcherAssert.assertThat((Object)newField.getName(), (Matcher)Matchers.is((Object)originalField.getName()));
        MatcherAssert.assertThat((Object)newField.getModifiers(), (Matcher)Matchers.is((Object)originalField.getModifiers()));
        MatcherAssert.assertThat((Object)newField.getName(), (Matcher)Matchers.is((Object)originalField.getName()));
        MatcherAssert.assertThat((Object)newField.getDefiningType(), IsType.isType(this.genericType));
        MatcherAssert.assertThat((Object)newField.getType(), IsType.isType(reifiedType));
    }

    @Test
    public void testFieldTypeConverted() {
        Object originalField = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("foo")).setDefiningType(this.nonGenericType)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setType(ArgumentTypeInfos.T)).build();
        this.fields.add((FieldInfo)originalField);
        this.fields.resolve();
        Iterable<FieldInfo> fields = this.initializer.get(this.genericType).all();
        MatcherAssert.assertThat(fields, (Matcher)Matchers.iterableWithSize((int)1));
        this.assertCloneField(Iterables.getOnlyElement(fields), (FieldInfo)originalField, TypeInfos.INTEGER);
    }

    @Test
    public void testFieldTypeNotConverted() {
        Object originalField = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("foo")).setDefiningType(this.nonGenericType)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setType(TypeInfos.STRING)).build();
        this.fields.add((FieldInfo)originalField);
        this.fields.resolve();
        Iterable<FieldInfo> fields = this.initializer.get(this.genericType).all();
        MatcherAssert.assertThat(fields, (Matcher)Matchers.iterableWithSize((int)1));
        this.assertCloneField(Iterables.getOnlyElement(fields), (FieldInfo)originalField, TypeInfos.STRING);
    }
}

