/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.MultipleFieldTable;
import apex.jorje.semantic.symbol.member.variable.ReifiedFieldInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.base.Equivalence;
import java.util.Map;

public class ReifiedFieldsInitializer
implements Initializer<FieldTable, TypeInfo> {
    @Override
    public FieldTable get(TypeInfo inputType) {
        GenericTypeInfo type = GenericTypeInfoUtil.asGenericType(inputType);
        assert (type.getUnreifiedType() != null) : "cannot create a reified field table for an unreified type";
        return this.createClonedFields(type, type.getRootUnreifiedType());
    }

    private FieldTable createClonedFields(GenericTypeInfo type, TypeInfo rootUnreifiedType) {
        Map<Equivalence.Wrapper<? extends TypeInfo>, TypeInfo> unparameterizedToParameterized = ArgumentTypeInfoConverter.getResolutionMap(type, rootUnreifiedType);
        MultipleFieldTable fields = new MultipleFieldTable();
        for (FieldInfo field : rootUnreifiedType.fields().all()) {
            TypeInfo fieldType = ArgumentTypeInfoConverter.convertType(unparameterizedToParameterized, field.getType());
            fields.add(new ReifiedFieldInfo(type, fieldType, field)).throwIfError();
        }
        return fields.resolve();
    }
}

