/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.services.I18nSupport;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PageTypeInfoTest
extends ValidationTest {
    private static final TypeInfo PAGE = TestSymbolResolvers.createEmptySymbols().getPageTypeInfo();

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Page p;", I18nSupport.getLabel("type.not.visible", PAGE)}, {"System.Page p;", I18nSupport.getLabel("type.not.visible", PAGE)}, {"new Page();", I18nSupport.getLabel("type.not.visible", PAGE)}, {"System.PageReference p = System.Page.foo;", I18nSupport.getLabel("page.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInvalidNamespaced() {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.assertFailure("System.PageReference p = System.Page.foo;", I18nSupport.getLabel("page.does.not.exist", "Apex__foo"));
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"PageReference s = Page.foo;"}, {"PageReference s = System.Page.foo;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.addTestPageReference("foo", "foo");
        this.tester.assertSuccess(code);
    }
}

