/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.JavaMethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class JavaTypeMethodTableInitializer
implements Initializer<MethodTable, TypeInfo> {
    static final String CALLING_FRAME_PROVIDER_CLASS_NAME = "apex.bytecodeinterpreter.ExceptionProvider$CallingFrameProvider";
    static final String EXECUTION_CONTEXT_CLASS_NAME = "apex.bytecodeinterpreter.ExecutionContext";
    static final String POSITION_PROVIDER_CLASS_NAME = "apex.ast.PositionProvider";
    static final String APEX_EXECUTION_CONTEXT_CLASS_NAME = "common.apex.runtime.ApexExecutionContext";
    static final String IGNORE_ANNOTATION_CLASS_NAME = "common.apex.runtime.ApexJavaBindingIgnore";
    private final Class<?> clazz;
    private final JavaTypeInfoUtil util;
    private final Class<Annotation> ignoreAnnotation;
    private final Class<?> apexExecutionContext;
    private final Class<?> positionProvider;
    private final Class<?> executionContext;
    private final Class<?> callingFrameProvider;

    public JavaTypeMethodTableInitializer(Class<?> clazz, JavaTypeInfoUtil util) {
        this.clazz = clazz;
        this.util = util;
        this.ignoreAnnotation = util.lookupClass(IGNORE_ANNOTATION_CLASS_NAME);
        this.apexExecutionContext = util.lookupClass(APEX_EXECUTION_CONTEXT_CLASS_NAME);
        this.positionProvider = util.lookupClass(POSITION_PROVIDER_CLASS_NAME);
        this.executionContext = util.lookupClass(EXECUTION_CONTEXT_CLASS_NAME);
        this.callingFrameProvider = util.lookupClass(CALLING_FRAME_PROVIDER_CLASS_NAME);
    }

    private List<Class<?>> getParameters(List<Class<?>> parameters) {
        if (parameters.size() >= 2 && this.apexExecutionContext != null && this.apexExecutionContext.isAssignableFrom(parameters.get(0)) && this.positionProvider != null && this.positionProvider.isAssignableFrom(parameters.get(1))) {
            return parameters.subList(2, parameters.size());
        }
        if (parameters.size() >= 2 && this.executionContext != null && this.executionContext.isAssignableFrom(parameters.get(0)) && this.callingFrameProvider != null && this.callingFrameProvider.isAssignableFrom(parameters.get(1))) {
            return parameters.subList(2, parameters.size());
        }
        return parameters;
    }

    @Override
    public MethodTable get(TypeInfo type) {
        ModifierGroup modifiers;
        JavaMethodTable methods = new JavaMethodTable();
        for (Method method : this.clazz.getMethods()) {
            modifiers = this.util.createModifiers(method.getModifiers());
            if (method.isBridge() || modifiers.not(ModifierTypeInfos.PUBLIC) || this.ignoreAnnotation != null && method.getAnnotation(this.ignoreAnnotation) != null) continue;
            List<Class<?>> parameterClasses = this.getParameters(Arrays.asList(method.getParameterTypes()));
            Class<?> returnClass = method.getReturnType();
            List<TypeInfo> parameterTypes = this.util.mapTypes(parameterClasses);
            StandardMethodInfoBuilder method2 = StandardMethodInfo.builder().setDefiningType(type).setName(method.getName()).setReturnType(this.util.mapType(method.getReturnType(), JavaTypeInfoUtil.TypeUsage.AS_RETURN)).setNamedParameterTypes(parameterTypes).setEmitSignature(SignatureFactory.create(method.getName(), this.util.mapType(returnClass, JavaTypeInfoUtil.TypeUsage.AS_EMIT_RETURN), parameterTypes)).setModifiers(modifiers).setGenerated(Generated.BUILT_IN);
            methods.addDuplicatesAllowed(method2.build());
        }
        for (Executable executable : this.clazz.getDeclaredConstructors()) {
            modifiers = this.util.createModifiers(((Constructor)executable).getModifiers());
            StandardMethodInfoBuilder method = StandardMethodInfo.builder().setDefiningType(type).setName("<init>").setNamedParameterTypes(this.util.mapTypes(this.getParameters(Arrays.asList(((Constructor)executable).getParameterTypes())))).setModifiers(modifiers).setGenerated(Generated.BUILT_IN).setConstructor();
            methods.addDuplicatesAllowed(method.build());
        }
        return methods.resolve();
    }
}

