/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import java.util.Arrays;
import java.util.List;

public class GenericTypeInfoFactory {
    private GenericTypeInfoFactory() {
    }

    public static GenericTypeInfo createList(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, elementType);
    }

    public static GenericTypeInfo createListIterator(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)WrapperTypeInfos.SYSTEM_LIST_ITERATOR, elementType);
    }

    public static GenericTypeInfo createSet(TypeInfo elementType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.SET, elementType);
    }

    public static GenericTypeInfo createMap(TypeInfo keyType, TypeInfo valueType) {
        return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.MAP, keyType, valueType);
    }

    public static GenericTypeInfo create(TypeInfo type, TypeInfo ... argumentTypes) {
        return GenericTypeInfoFactory.create(type, Arrays.asList(argumentTypes));
    }

    public static GenericTypeInfo create(TypeInfo unreifiedType, List<TypeInfo> argumentTypes) {
        assert (unreifiedType != null && argumentTypes != null) : "parameters cannot be null";
        assert (!argumentTypes.isEmpty()) : "argument types must be non empty";
        if (!unreifiedType.isResolved() || GenericTypeInfoFactory.isUnresolved(argumentTypes)) {
            return UnresolvedTypeInfoFactory.create(unreifiedType, argumentTypes);
        }
        return GenericTypeInfo.builder().setUnreifiedType(unreifiedType).setTypeArguments(argumentTypes).build();
    }

    private static boolean isUnresolved(List<TypeInfo> argumentTypes) {
        for (TypeInfo argumentType : argumentTypes) {
            if (argumentType.isResolved()) continue;
            return true;
        }
        return false;
    }
}

