/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import java.util.Collections;
import java.util.List;

class GenericTypeInfoDepthCalculator {
    GenericTypeInfoDepthCalculator() {
    }

    public static int calculate(TypeInfo type) {
        return GenericTypeInfoDepthCalculator.calculate(type.getTypeArguments(), 0);
    }

    public static int calculate(List<TypeInfo> types) {
        return GenericTypeInfoDepthCalculator.calculate(types, 0);
    }

    private static int calculate(List<TypeInfo> types, final int startingValue) {
        if (startingValue >= GenericTypeInfo.MAX_SIZE) {
            return startingValue + 1;
        }
        List argDepths = types.stream().map(type -> type.accept(new TypeInfoVisitor.Default<Integer>(){

            @Override
            protected Integer _default(TypeInfo type) {
                return startingValue + 1;
            }

            @Override
            public Integer visit(GenericTypeInfo type) {
                return GenericTypeInfoDepthCalculator.calculate(type.getTypeArguments(), startingValue + 1);
            }
        })).collect(MoreIterables.toUnmodifiableList(types.size()));
        return argDepths.isEmpty() ? 0 : (Integer)Collections.max(argDepths);
    }
}

