/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.iterable.MoreLists;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BuiltInTypeInfoTest {
    @Test
    public void testBytecodeInstanceName() {
        MatcherAssert.assertThat((Object)TypeInfos.INTEGER.getBytecodeName(), (Matcher)Matchers.is((Object)"java/lang/Integer"));
    }

    @Test
    public void testTypeSignature() {
        MatcherAssert.assertThat((Object)TypeInfos.INTEGER.getTypeSignature(), (Matcher)Matchers.is((Object)"Ljava/lang/Integer;"));
        MatcherAssert.assertThat((Object)TypeInfos.VOID.getTypeSignature(), (Matcher)Matchers.is((Object)"V"));
    }

    @DataProvider
    Object[][] allApexTypes() {
        return MoreLists.to2dArray(TypeInfo.class, TypeInfoTables.TYPES_BY_APEX_NAME.values());
    }

    @Test(dataProvider="allApexTypes")
    public void testValidMethods(TypeInfo type) {
        MatcherAssert.assertThat((String)(type + " invalid methods"), (Object)type.methods(), (Matcher)Matchers.notNullValue());
    }

    @Test(dataProvider="allApexTypes")
    public void testValidFields(TypeInfo type) {
        MatcherAssert.assertThat((String)(type + " invalid fields"), (Object)type.fields(), (Matcher)Matchers.notNullValue());
    }

    @Test(dataProvider="allApexTypes")
    public void testValidParents(TypeInfo type) {
        MatcherAssert.assertThat((String)(type + " invalid parents"), (Object)type.parents(), (Matcher)Matchers.notNullValue());
    }
}

