/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRuleGroup;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.services.Version;

public class AnnotationProperty {
    private final String name;
    private final boolean required;
    private final Initializer<Object, Version> defaultValue;
    private final Type type;
    private final AnnotationPropertyRuleGroup rules;

    private AnnotationProperty(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
        this.rules = builder.rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        return this.type;
    }

    public Initializer<Object, Version> getDefaultValue() {
        return this.defaultValue;
    }

    public AnnotationPropertyRuleGroup getRules() {
        return this.rules;
    }

    static class Builder {
        private String name;
        private boolean required;
        private Type type;
        private Initializer<Object, Version> defaultValue;
        private AnnotationPropertyRuleGroup rules;

        Builder() {
        }

        Builder setName(String name) {
            this.name = name;
            this.type = Type.STRING;
            this.rules = AnnotationPropertyRuleGroup.NONE;
            return this;
        }

        Builder setRequired() {
            this.required = true;
            return this;
        }

        Builder setType(Type type) {
            this.type = type;
            return this;
        }

        Builder defaultValue(Object defaultValue) {
            this.defaultValue = Initializers.ofInstance(defaultValue);
            return this;
        }

        Builder defaultValue(Initializer<Object, Version> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        Builder setRules(AnnotationPropertyRuleGroup rules) {
            this.rules = rules;
            return this;
        }

        private boolean assertRules() {
            boolean validRules = true;
            for (AnnotationPropertyRule rule : this.rules.getRules()) {
                validRules &= rule.getAllowedTypes().contains((Object)this.type);
            }
            return validRules;
        }

        AnnotationProperty build() {
            assert (this.assertRules()) : "Invalid rule type";
            return new AnnotationProperty(this);
        }
    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        STRING;

    }
}

