/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.common.util.StringUtil;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.MultipleFieldTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.ModifiersMatchBlock;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.services.MyInterner;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractTypeInfo
implements TypeInfo {
    private static final Equivalence<TypeInfo> TYPE_INFO_WRAPPER = new TypeInfoEquivalence();
    private final String apexName;
    private final String bytecodeMethodName;
    private final String bytecodeName;
    private final String typeSignature;
    private final TypeInfo enclosingType;
    private final Namespace namespace;
    private final ModifierGroup modifiers;
    private final BasicType basicType;
    private final UnitType unitType;
    private final boolean resolved;
    private final Initializer<ParentTable, TypeInfo> parents;
    private final Initializer<FieldTable, TypeInfo> fields;
    private final Initializer<MethodTable, TypeInfo> methods;
    private final Initializer<MethodTable, TypeInfo> virtualMethods;
    private final Initializer<CodeUnitDetails, TypeInfo> codeUnit;
    private final Equivalence.Wrapper<? extends TypeInfo> typeComparator;

    public AbstractTypeInfo(Builder<? extends Builder, ? extends AbstractTypeInfo> builder) {
        this.apexName = MyInterner.intern(((Builder)builder).apexName);
        this.bytecodeName = MyInterner.intern(((Builder)builder).bytecodeName);
        this.bytecodeMethodName = MyInterner.intern(MoreObjects.firstNonNull(((Builder)builder).bytecodeMethodName, this.bytecodeName));
        this.typeSignature = MyInterner.intern(builder.buildTypeSignature());
        this.resolved = ((Builder)builder).resolved;
        this.enclosingType = ((Builder)builder).enclosingType;
        this.namespace = ((Builder)builder).namespace;
        this.modifiers = ((Builder)builder).modifiers;
        this.parents = ((Builder)builder).parents;
        this.methods = ((Builder)builder).methods;
        this.virtualMethods = MoreObjects.firstNonNull(((Builder)builder).virtualMethods, this.methods);
        this.fields = ((Builder)builder).fields;
        this.unitType = ((Builder)builder).unitType;
        this.basicType = ((Builder)builder).basicType;
        this.codeUnit = ((Builder)builder).codeUnit;
        this.typeComparator = TYPE_INFO_WRAPPER.wrap(this);
        assert (this.apexName != null) : "no apex name defined";
        assert (this.bytecodeName != null) : "no bytecode name defined";
        assert (this.unitType != null) : "no unit type defined";
        assert (this.basicType != null) : "no basic type defined";
        assert (this.namespace != null) : "no namespace defined";
        assert (this.parents != null) : "no parents defined";
        assert (this.methods != null) : "no methods defined";
        assert (this.fields != null) : "no fields defined";
    }

    @Override
    public BasicType getBasicType() {
        return this.basicType;
    }

    @Override
    public String getBytecodeMethodName() {
        return this.bytecodeMethodName;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public UnitType getUnitType() {
        return this.unitType;
    }

    @Override
    public MethodTable methods() {
        return this.methods.get(this);
    }

    @Override
    public MethodTable virtualMethods() {
        return this.virtualMethods.get(this);
    }

    @Override
    public FieldTable fields() {
        return this.fields.get(this);
    }

    @Override
    public ParentTable parents() {
        return this.parents.get(this);
    }

    @Override
    public String getBytecodeName() {
        return this.bytecodeName;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<TypeInfo> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public TypeInfo getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public Equivalence.Wrapper<? extends TypeInfo> getEquivalenceWrapper() {
        return this.typeComparator;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public String getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public CodeUnitDetails getCodeUnitDetails() {
        return this.codeUnit.get(this);
    }

    @Override
    public String getApexName() {
        return this.apexName;
    }

    public String toString() {
        return this.getApexName();
    }

    public static abstract class Builder<B extends Builder, T extends AbstractTypeInfo>
    implements TypeNameProvider {
        private String apexName;
        private String bytecodeName;
        private String bytecodeMethodName;
        private BasicType basicType;
        private Initializer<FieldTable, TypeInfo> fields;
        private Initializer<MethodTable, TypeInfo> methods;
        private Initializer<MethodTable, TypeInfo> virtualMethods;
        private Initializer<ParentTable, TypeInfo> parents;
        private Initializer<CodeUnitDetails, TypeInfo> codeUnit;
        private Namespace namespace;
        private UnitType unitType;
        private ModifierGroup modifiers;
        private boolean resolved = true;
        private TypeInfo enclosingType;
        private String typeSignature;

        protected Builder() {
            this.setCodeUnitDetails(CodeUnitDetailsProvider.NONE);
        }

        public abstract T build();

        public T buildResolved() {
            this.setResolvedDefaults();
            return this.build();
        }

        public String buildTypeSignature() {
            return this.typeSignature != null ? this.typeSignature : TypeNameUtil.createTypeSignature(this.getBytecodeName());
        }

        public B setResolved(boolean resolved) {
            this.resolved = resolved;
            return (B)this;
        }

        public B setCodeUnitDetails(Initializer<CodeUnitDetails, TypeInfo> codeUnit) {
            this.codeUnit = Initializers.memoize(codeUnit);
            return (B)this;
        }

        public B setFileBase(SourceFile source, CompilationUnit compilationUnit) {
            return this.setFileBase(source, null, compilationUnit);
        }

        public B setFileBase(SourceFile source, TypeInfo enclosingType, CompilationUnit compilationUnit) {
            FieldTable fields;
            switch (compilationUnit.match(UnitType.TO_UNIT_TYPE)) {
                case TRIGGER: {
                    fields = new StandardFieldTable();
                    break;
                }
                default: {
                    fields = new MultipleFieldTable();
                }
            }
            this.setUnitType(compilationUnit.match(UnitType.TO_UNIT_TYPE));
            this.setFields(fields);
            this.setMethods(new StandardMethodTable());
            this.setVirtualMethods(new StandardMethodTable());
            this.setParents(new StandardParentTable());
            this.setModifiers(compilationUnit.match(new ModifiersMatchBlock()));
            this.setNamespace(source.getNamespace());
            this.setEnclosingType(enclosingType);
            this.setCodeUnitDetails(type -> new CodeUnitDetailsProvider.SourceCodeUnitDetails((TypeInfo)type, source, compilationUnit));
            Pair<String, String> typeNames = TypeNameFactory.create(source, enclosingType, compilationUnit);
            this.apexName = (String)typeNames.left;
            this.bytecodeName = (String)typeNames.right;
            this.basicType = BasicType.APEX_OBJECT;
            return (B)this;
        }

        public B setEnclosingType(TypeInfo enclosingType) {
            this.enclosingType = enclosingType;
            return (B)this;
        }

        public B setModifiers(ModifierGroup modifiers) {
            this.modifiers = modifiers;
            return (B)this;
        }

        public B setNameViaClass(Class<?> clazz) {
            this.bytecodeName = StringUtil.toBytecodeName(clazz);
            this.apexName = clazz.getSimpleName();
            return (B)this;
        }

        public B setBytecodeMethodName(String bytecodeMethodName) {
            this.bytecodeMethodName = bytecodeMethodName;
            return (B)this;
        }

        public B setBasicType(BasicType basicType) {
            this.basicType = basicType;
            return (B)this;
        }

        public B setApexBytecodeName(String apexBytecodeName) {
            return ((Builder)this.setApexName(apexBytecodeName)).setBytecodeName(apexBytecodeName);
        }

        public B setParents(Initializer<ParentTable, TypeInfo> parents) {
            this.parents = parents;
            return (B)this;
        }

        public B setParents(ParentTable parents) {
            return this.setParents(Initializers.ofInstance(parents));
        }

        public B setParents(TypeInfo superType) {
            return this.setParents(superType, Collections.emptySet());
        }

        public B setParents(TypeInfo superType, TypeInfo ... interfaces) {
            return this.setParents(superType, Sets.newHashSet(interfaces));
        }

        @Override
        public String getApexName() {
            return this.apexName;
        }

        public B setParents(TypeInfo superType, Set<TypeInfo> interfaces) {
            return this.setParents(ParentTableFactory.create(superType, interfaces));
        }

        public B setFields(Initializer<FieldTable, TypeInfo> fields) {
            this.fields = fields;
            return (B)this;
        }

        @Override
        public String getBytecodeName() {
            return this.bytecodeName;
        }

        public B setFields(FieldTable fields) {
            return this.setFields(Initializers.ofInstance(fields));
        }

        public B setUnitType(UnitType unitType) {
            this.unitType = unitType;
            return (B)this;
        }

        @Override
        public String getTypeSignature() {
            return this.typeSignature == null ? this.buildTypeSignature() : this.typeSignature;
        }

        protected Namespace getNamespace() {
            return this.namespace;
        }

        public B setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return (B)this;
        }

        public B setMethods(MethodTable methods) {
            return this.setMethods(Initializers.ofInstance(methods));
        }

        public B setMethods(Initializer<MethodTable, TypeInfo> methods) {
            this.methods = methods;
            return (B)this;
        }

        public B setVirtualMethods(MethodTable virtualMethods) {
            return this.setVirtualMethods(Initializers.ofInstance(virtualMethods));
        }

        public B setApexName(String apexName) {
            this.apexName = apexName;
            return (B)this;
        }

        public B setVirtualMethods(Initializer<MethodTable, TypeInfo> virtualMethods) {
            this.virtualMethods = virtualMethods;
            return (B)this;
        }

        protected B setResolvedDefaults() {
            this.fields = MoreObjects.firstNonNull(this.fields, FieldTable.EMPTY);
            this.methods = MoreObjects.firstNonNull(this.methods, MethodTable.EMPTY);
            this.parents = MoreObjects.firstNonNull(this.parents, ParentTable.EMPTY);
            this.unitType = MoreObjects.firstNonNull(this.unitType, UnitType.CLASS);
            this.namespace = MoreObjects.firstNonNull(this.namespace, Namespaces.EMPTY);
            this.modifiers = MoreObjects.firstNonNull(this.modifiers, ModifierGroups.GLOBAL_FINAL);
            this.basicType = MoreObjects.firstNonNull(this.basicType, BasicType.APEX_OBJECT);
            return (B)this;
        }

        public B setTypeSignature(String typeSignature) {
            this.typeSignature = typeSignature;
            return (B)this;
        }

        public B setBytecodeName(String bytecodeName) {
            this.bytecodeName = bytecodeName;
            return (B)this;
        }
    }
}

