/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.Version;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class VfComponentThreeTest
extends ResolveRuleTest {
    @BeforeMethod
    public void setUp() {
        Mockito.when((Object)this.referencingType.getNamespace()).thenReturn((Object)NAMESPACE);
    }

    @Test
    public void testLookup() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", NAMESPACE.toString(), "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testLookupConvertCNamespace() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", "c", "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testNotComponentNamespace() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("notComponent", NAMESPACE.toString(), "foo")), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testWrongDestinationNamespace() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, Namespaces.DATABASE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", NAMESPACE.toString(), "foo")), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testOldVersion() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.MIN);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", NAMESPACE.toString(), "foo")), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testOldVersionWithPermission() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.MIN);
        Mockito.when((Object)this.access.hasPermission(PlaceholderOrgPerm.VISUAL_FORCE_APEX_TESTING)).thenReturn((Object)true);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", NAMESPACE.toString(), "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testOldVersionButTrusted() {
        Mockito.when((Object)((Object)this.codeUnit.getVersion())).thenReturn((Object)Version.MIN);
        Mockito.when((Object)this.access.isReservedNamespace(NAMESPACE)).thenReturn((Object)true);
        Mockito.when((Object)this.provider.getVfComponentType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.VfComponentTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("component", NAMESPACE.toString(), "foo")), IsType.isType(this.lookupType));
    }
}

