/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRule;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.MyInterner;
import apex.jorje.services.Version;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.regex.Pattern;

final class TypeNameResolveRules {
    private static final Pattern SYSTEM = Pattern.compile("(?i)system");
    private static final Pattern LABEL = Pattern.compile("(?i)label");
    private static final Pattern BASE_EXCEPTION = Pattern.compile("(?i)exception");

    private TypeNameResolveRules() {
    }

    private static TypeInfo lookupInBuiltInNamespace(StandardSymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = "com/salesforce/api/" + TypeNameUtil.toNamespaceLower(namespace, name);
        return symbols.find(referencingType, MyInterner.intern(fullName));
    }

    private static TypeInfo lookupInBuiltInException(StandardSymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = namespace.equals(Namespaces.SYSTEM) ? "com/salesforce/api/exception/" + name : "com/salesforce/api/exception/" + TypeNameUtil.toNamespaceLower(namespace, name);
        return symbols.find(referencingType, MyInterner.intern(fullName));
    }

    private static boolean hasVfComponentTypes(StandardSymbolResolver symbols, TypeInfo referencingType) {
        return symbols.getAccessEvaluator().isReservedNamespace(referencingType.getNamespace()) || symbols.getAccessEvaluator().hasPermission(PlaceholderOrgPerm.VISUAL_FORCE_APEX_TESTING) || Version.V172.isLessThanOrEqual(referencingType.getCodeUnitDetails().getVersion());
    }

    private static boolean isSystem(String name) {
        return SYSTEM.matcher(name).matches();
    }

    private static boolean isLabel(String name) {
        return LABEL.matcher(name).matches();
    }

    private static boolean isBaseException(String name) {
        return BASE_EXCEPTION.matcher(name).matches();
    }

    static class SystemLabelNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new SystemLabelNamespace();

        private SystemLabelNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            return TypeNameResolveRules.isSystem(typeName.get(0)) && TypeNameResolveRules.isLabel(typeName.get(1)) ? symbols.getLabelTypeInfo(Namespaces.parse(typeName.get(2))) : null;
        }
    }

    static class SystemLabel
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new SystemLabel();

        private SystemLabel() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            return TypeNameResolveRules.isSystem(typeName.get(0)) && TypeNameResolveRules.isLabel(typeName.get(1)) ? symbols.getLabelTypeInfo(Namespaces.EMPTY) : null;
        }
    }

    static class LabelNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new LabelNamespace();

        private LabelNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            return TypeNameResolveRules.isLabel(typeName.get(0)) ? symbols.getLabelTypeInfo(Namespaces.parse(typeName.get(1))) : null;
        }
    }

    static class Label
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new Label();

        private Label() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return TypeNameResolveRules.isLabel(typeName.get(0)) ? symbols.getLabelTypeInfo(Namespaces.EMPTY) : null;
        }
    }

    static class Pre146ListException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new Pre146ListException();

        private Pre146ListException() {
            super(null, Version.V146);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return "ListException".equalsIgnoreCase(typeName.get(0)) ? InternalTypeInfos.ARRAY_EXCEPTION : null;
        }
    }

    static class Pre146SystemListException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new Pre146SystemListException();

        private Pre146SystemListException() {
            super(null, Version.V146);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            return "system".equalsIgnoreCase(typeName.get(0)) && "listException".equalsIgnoreCase(typeName.get(1)) ? InternalTypeInfos.ARRAY_EXCEPTION : null;
        }
    }

    static class Pre146SystemArrayException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new Pre146SystemArrayException();

        private Pre146SystemArrayException() {
            super(null, Version.V146);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            return "system".equalsIgnoreCase(typeName.get(0)) && "arrayException".equalsIgnoreCase(typeName.get(1)) ? InternalTypeInfos.ARRAY_EXCEPTION : null;
        }
    }

    static class Pre146ArrayException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new Pre146ArrayException();

        private Pre146ArrayException() {
            super(null, Version.V146);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return "ArrayException".equalsIgnoreCase(typeName.get(0)) ? InternalTypeInfos.ARRAY_EXCEPTION : null;
        }
    }

    static class ArrayException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new ArrayException();

        private ArrayException() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return "ArrayException".equalsIgnoreCase(typeName.get(0)) ? TypeNameResolveRules.lookupInBuiltInException(symbols, referencingType, Namespaces.SYSTEM, "listexception") : null;
        }
    }

    static class ApexPagesMappedTypes
    extends TypeNameResolveRule {
        public static final ApexPagesMappedTypes INSTANCE = new ApexPagesMappedTypes();

        private ApexPagesMappedTypes() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            if (typeName.get(0).equalsIgnoreCase("ApexPages")) {
                return TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, typeName.get(1));
            }
            return null;
        }
    }

    static class TwoPartSystemExceptions
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new TwoPartSystemExceptions();

        private TwoPartSystemExceptions() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            if (TypeNameResolveRules.isSystem(typeName.get(0))) {
                if (TypeNameResolveRules.isBaseException(typeName.get(1))) {
                    return TypeInfos.EXCEPTION;
                }
                if (TypeNameUtil.isException(typeName.get(1))) {
                    return TypeNameResolveRules.lookupInBuiltInException(symbols, referencingType, Namespaces.SYSTEM, typeName.get(1));
                }
            }
            return null;
        }
    }

    static class BuiltInNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new BuiltInNamespace();

        private BuiltInNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            String candidateName = "com/salesforce/api/" + TypeNameUtil.toNamespaceLower(typeName.get(0), typeName.get(1));
            TypeInfo type = symbols.find(referencingType, candidateName);
            if (type != null) {
                return type;
            }
            if (TypeNameResolveRules.isSystem(typeName.get(0))) {
                return symbols.find(referencingType, "com/salesforce/api/" + typeName.get(1));
            }
            return null;
        }
    }

    static class GlobalModuleOuterInner
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new GlobalModuleOuterInner();

        private GlobalModuleOuterInner() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 4);
            Namespace namespace = Namespaces.parse(typeName.get(0), typeName.get(1));
            String candidateName = TypeNameUtil.toNamespaceLower(namespace.getNameLower(), TypeNameUtil.toInnerTypeLower(typeName.get(2), typeName.get(3)));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class GlobalModuleOuter
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new GlobalModuleOuter();

        private GlobalModuleOuter() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            Namespace namespace = Namespaces.parse(typeName.get(0), typeName.get(1));
            String candidateName = TypeNameUtil.toNamespaceLower(namespace.getNameLower(), typeName.get(2));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class NamespaceOuterInner
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new NamespaceOuterInner();

        private NamespaceOuterInner() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            String candidateName = TypeNameUtil.toNamespaceLower(typeName.get(0), TypeNameUtil.toInnerTypeLower(typeName.get(1), typeName.get(2)));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class PreV148SystemSystemException
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new PreV148SystemSystemException();

        private PreV148SystemSystemException() {
            super(null, Version.V148);
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            return TypeNameResolveRules.isSystem(typeName.get(0)) && TypeNameResolveRules.isSystem(typeName.get(1)) && TypeNameUtil.isException(typeName.get(2)) ? TypeInfos.EXCEPTION : null;
        }
    }

    static class NamespaceAndTopLevelType
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new NamespaceAndTopLevelType();

        private NamespaceAndTopLevelType() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            String candidateName = TypeNameUtil.toNamespaceLower(typeName.get(0), typeName.get(1));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class InnerClassInSystemNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new InnerClassInSystemNamespace();

        private InnerClassInSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            String candidateName = TypeNameUtil.toNamespaceLower(Namespaces.SYSTEM, TypeNameUtil.toInnerTypeLower(typeName.get(0), typeName.get(1)));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class InnerClassInSameNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new InnerClassInSameNamespace();

        private InnerClassInSameNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            Namespace namespace = referencingType.getNamespace();
            String candidateName = TypeNameUtil.toInnerTypeLower(typeName.get(0), typeName.get(1));
            if (!Namespace.isEmptyOrNull(namespace)) {
                candidateName = TypeNameUtil.toNamespaceLower(namespace, candidateName);
            }
            return symbols.find(referencingType, candidateName);
        }
    }

    static class FlowInterviewTypeFour
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new FlowInterviewTypeFour();

        private FlowInterviewTypeFour() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 4);
            Namespace outerNamespace = Namespaces.parse(typeName.get(0));
            if (Namespaces.FLOW.equalsGlobal(outerNamespace) && "interview".equalsIgnoreCase(typeName.get(1))) {
                Namespace namespace = Namespaces.parse(typeName.get(2));
                return symbols.getSymbolProvider().getFlowInterviewType(symbols, referencingType, namespace, typeName.get(3));
            }
            return null;
        }
    }

    static class FlowInterviewTypeThree
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new FlowInterviewTypeThree();

        private FlowInterviewTypeThree() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            Namespace outerNamespace = Namespaces.parse(typeName.get(0));
            if (Namespaces.FLOW.equalsGlobal(outerNamespace) && "interview".equalsIgnoreCase(typeName.get(1))) {
                Namespace namespace = referencingType.getNamespace();
                return symbols.getSymbolProvider().getFlowInterviewType(symbols, referencingType, namespace, typeName.get(2));
            }
            return null;
        }
    }

    static class VfComponentTypeThree
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new VfComponentTypeThree();

        private VfComponentTypeThree() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 3);
            Namespace outerNamespace = Namespaces.parse(typeName.get(0));
            if (TypeNameResolveRules.hasVfComponentTypes(symbols, referencingType) && Namespaces.VF_COMPONENT.equals(outerNamespace)) {
                Namespace myNamespace = Namespaces.parse(typeName.get(1));
                Namespace innerNamespace = Namespaces.VF.equals(myNamespace) ? referencingType.getNamespace() : myNamespace;
                return symbols.getSymbolProvider().getVfComponentType(symbols, referencingType, innerNamespace, typeName.get(2));
            }
            return null;
        }
    }

    static class VfComponentTypeTwo
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new VfComponentTypeTwo();

        private VfComponentTypeTwo() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            Namespace outerNamespace = Namespaces.parse(typeName.get(0));
            if (TypeNameResolveRules.hasVfComponentTypes(symbols, referencingType) && Namespaces.VF_COMPONENT.equals(outerNamespace)) {
                Namespace innerNamespace = referencingType.getNamespace();
                return symbols.getSymbolProvider().getVfComponentType(symbols, referencingType, innerNamespace, typeName.get(1));
            }
            return null;
        }
    }

    static class BuiltInMethodNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new BuiltInMethodNamespace();

        private BuiltInMethodNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeNames) {
            assert (typeNames.size() == 1);
            String typeName = typeNames.get(0);
            TypeInfo type = TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, typeName);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SCHEMA, typeName);
            if (type != null) {
                return type;
            }
            return TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.EMPTY, typeName);
        }
    }

    static class BuiltInSystemSchema
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new BuiltInSystemSchema();

        private BuiltInSystemSchema() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeNames) {
            assert (typeNames.size() == 1);
            String typeName = typeNames.get(0);
            TypeInfo type = TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, typeName);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveRules.lookupInBuiltInException(symbols, referencingType, Namespaces.SYSTEM, typeName);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SCHEMA, typeName);
            if (type != null) {
                return type;
            }
            if (typeName.equals("database")) {
                return TypeNameResolveRules.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.EMPTY, typeName);
            }
            return null;
        }
    }

    static class TwoPartSystemNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new TwoPartSystemNamespace();

        private TwoPartSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            if (referencingType.getCodeUnitDetails().getVersion().isLessThan(Version.V156) || typeName.get(0).equalsIgnoreCase(Namespaces.SYSTEM.toString())) {
                String name;
                List<String> names = typeName.subList(1, 2);
                TypeInfo type = FileBaseSystemNamespace.INSTANCE.lookup(symbols, referencingType, names);
                if (type != null) {
                    return type;
                }
                switch (name = Iterables.getLast(names)) {
                    case "date": {
                        return TypeInfos.DATE;
                    }
                    case "datetime": {
                        return TypeInfos.DATE_TIME;
                    }
                }
            }
            return null;
        }
    }

    static class FileBaseSystemNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new FileBaseSystemNamespace();

        private FileBaseSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return symbols.find(referencingType, TypeNameUtil.toNamespaceLower(Namespaces.SYSTEM, typeName.get(0)));
        }
    }

    static class TopLevelUdtInSameNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new TopLevelUdtInSameNamespace();

        private TopLevelUdtInSameNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            String candidateName = TypeNameUtil.toNamespaceLower(referencingType.getNamespace(), typeName.get(0));
            return symbols.find(referencingType, candidateName);
        }
    }

    static class InnerClassOfParentClass
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new InnerClassOfParentClass();

        private InnerClassOfParentClass() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            if (!referencingType.parents().isResolved()) {
                return null;
            }
            TypeInfo currentType = referencingType.parents().superType();
            while (currentType != null) {
                String innerTypeName = TypeNameUtil.toInnerTypeLower(currentType.getBytecodeName(), typeName.get(0));
                TypeInfo foundTypeInfo = symbols.find(referencingType, innerTypeName);
                if (foundTypeInfo != null) {
                    return foundTypeInfo;
                }
                currentType = currentType.parents().superType();
            }
            return null;
        }
    }

    static class InnerClassOfEnclosingClass
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new InnerClassOfEnclosingClass();

        private InnerClassOfEnclosingClass() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            if (TypeInfoUtil.isTopLevel(referencingType)) {
                return null;
            }
            TypeInfo currentType = TypeInfoUtil.getTopLevel(referencingType);
            String innerTypeName = TypeNameUtil.toInnerTypeLower(currentType.getBytecodeName(), typeName.get(0));
            return symbols.get(innerTypeName);
        }
    }

    static class InnerClassOfCurrentClass
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new InnerClassOfCurrentClass();

        private InnerClassOfCurrentClass() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            String innerTypeName = TypeNameUtil.toInnerTypeLower(referencingType.getBytecodeName(), typeName.get(0));
            return symbols.get(innerTypeName);
        }
    }

    static class ArgumentType
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new ArgumentType();

        private ArgumentType() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, final List<String> typeName) {
            assert (typeName.size() == 1);
            if (symbols.staticContext().exists() && symbols.staticContext().get()) {
                return null;
            }
            return referencingType.accept(new TypeInfoVisitor.Default<TypeInfo>(){

                @Override
                protected TypeInfo _default(TypeInfo type) {
                    return null;
                }

                @Override
                public TypeInfo visit(GenericTypeInfo type) {
                    return type.getTypeArguments().stream().filter(argumentType -> argumentType.getApexName().equalsIgnoreCase((String)typeName.get(0))).findFirst().orElseGet(() -> null);
                }
            });
        }
    }

    static class FileBaseSchemaNamespace
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new FileBaseSchemaNamespace();

        private FileBaseSchemaNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return symbols.find(referencingType, TypeNameUtil.toNamespaceLower(Namespaces.SCHEMA, typeName.get(0)));
        }
    }

    static class SchemaSObject
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new SchemaSObject();

        private SchemaSObject() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 2);
            if (typeName.get(0).equalsIgnoreCase(Namespaces.SCHEMA.toString())) {
                return symbols.getSymbolProvider().getSObjectType(referencingType, typeName.get(1));
            }
            return null;
        }
    }

    static class SObject
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new SObject();

        private SObject() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            return symbols.getSymbolProvider().getSObjectType(referencingType, typeName.get(0));
        }
    }

    static class NamedScalarOrVoid
    extends TypeNameResolveRule {
        public static final TypeNameResolveRule INSTANCE = new NamedScalarOrVoid();

        private NamedScalarOrVoid() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, List<String> typeName) {
            assert (typeName.size() == 1);
            TypeInfo type = TypeInfoTables.TYPES_BY_APEX_NAME.get(typeName.get(0));
            if (type == null) {
                return null;
            }
            Version version = referencingType.getCodeUnitDetails().getVersion();
            return version.isGreaterThanOrEqual(type.getBasicType().getMinVersion()) ? type : null;
        }
    }
}

