/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Version;
import java.util.List;

public abstract class TypeNameResolveRule {
    private final Version minVersion;
    private final Version maxVersion;

    TypeNameResolveRule() {
        this(null, null);
    }

    TypeNameResolveRule(Version minVersion, Version maxVersion) {
        if (maxVersion != null && !maxVersion.isGreaterThanOrEqual(minVersion)) {
            throw new IllegalArgumentException("maxVersion has to be at least minVersion");
        }
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public final boolean isApplicableToVersion(Version version) {
        return !(version != null && !version.isGreaterThanOrEqual(this.minVersion) || this.maxVersion != null && !this.maxVersion.isGreaterThanOrEqual(version));
    }

    public abstract TypeInfo lookup(StandardSymbolResolver var1, TypeInfo var2, List<String> var3);
}

