/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InnerClassOfParentClassTest
extends ResolveRuleTest {
    @BeforeMethod
    public void setUp() {
        Mockito.when((Object)this.referencingType.getBytecodeName()).thenReturn((Object)"outer");
        Mockito.when((Object)this.superType.getBytecodeName()).thenReturn((Object)"super");
    }

    @Test
    public void testNoParentType() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassOfParentClass.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testParentType() {
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superType);
        Mockito.when((Object)this.symbols.find(this.referencingType, "super$foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassOfParentClass.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testNoSuperParentType() {
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassOfParentClass.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), (Matcher)Matchers.nullValue());
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.InnerClassOfParentClass.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

