/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class InnerClassInSameNamespaceTest
extends ResolveRuleTest {
    private static final Namespace NAMESPACE = Namespaces.create("namespace", "module");

    @Test
    public void testCurrentTypeNoNamespace() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "outertype$foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("outerType", "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testCurrentTypeNamespace() {
        Mockito.when((Object)this.referencingType.getNamespace()).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.symbols.find(this.referencingType, "namespace__module/outertype$foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("outerType", "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testCurrentTypeNamespaceNoInnerType() {
        Mockito.when((Object)this.referencingType.getNamespace()).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.symbols.find(this.referencingType, "outertype$foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("outerType", "foo")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCurrentTypeNoNamespaceNoInnerType() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.InnerClassInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("outerType", "foo")), (Matcher)Matchers.nullValue());
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.InnerClassInSameNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo"));
    }
}

