/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FlowInterviewThreeTest
extends ResolveRuleTest {
    @BeforeMethod
    public void setUp() {
        Mockito.when((Object)this.referencingType.getNamespace()).thenReturn((Object)NAMESPACE);
    }

    @Test
    public void testLookup() {
        Mockito.when((Object)this.provider.getFlowInterviewType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FlowInterviewTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("flow", "interview", "foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testNoInterview() {
        Mockito.when((Object)this.provider.getFlowInterviewType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FlowInterviewTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("flow", "blah", "foo")), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testNoFlow() {
        Mockito.when((Object)this.provider.getFlowInterviewType(this.symbols, this.referencingType, NAMESPACE, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FlowInterviewTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("blah", "interview", "foo")), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testWrongNamespace() {
        Mockito.when((Object)this.provider.getFlowInterviewType(this.symbols, this.referencingType, Namespaces.APEX, "foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.FlowInterviewTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("flow", "interview", "foo")), (Matcher)IsNull.nullValue());
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.FlowInterviewTypeThree.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("flow", "interview"));
    }
}

