/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class BuiltInMethodNamespaceTest
extends ResolveRuleTest {
    @Test
    public void testNoType() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.BuiltInMethodNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSystemType() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/system/foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.BuiltInMethodNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testSchemaType() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/schema/foo")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.BuiltInMethodNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo")), IsType.isType(this.lookupType));
    }

    @Test
    public void testNoNamespaceType() {
        Mockito.when((Object)this.symbols.find(this.referencingType, "com/salesforce/api/database")).thenReturn((Object)this.lookupType);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.BuiltInMethodNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("database")), IsType.isType(this.lookupType));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.BuiltInMethodNamespace.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }
}

