/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.symbol.resolver.rules.ResolveRuleTest;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRules;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class ArgumentTypeTest
extends ResolveRuleTest {
    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidTypeName() {
        TypeNameResolveRules.ArgumentType.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("foo", "bar"));
    }

    @Test
    public void testValidType() {
        this.referencingType = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"foo"))).build();
        MatcherAssert.assertThat((Object)TypeNameResolveRules.ArgumentType.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList(ArgumentTypeInfos.T.getApexName())), IsType.isType(ArgumentTypeInfos.T));
    }

    @Test
    public void testStaticContext() {
        this.referencingType = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"foo"))).build();
        this.symbols.staticContext().set(true);
        MatcherAssert.assertThat((Object)TypeNameResolveRules.ArgumentType.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList(ArgumentTypeInfos.T.getApexName())), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testNoType() {
        MatcherAssert.assertThat((Object)TypeNameResolveRules.ArgumentType.INSTANCE.lookup(this.symbols, this.referencingType, Lists.newArrayList("bar")), (Matcher)Matchers.nullValue());
    }
}

