/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VisibilityTest {
    private static final ModifierGroup PUBLIC_GROUP = ModifierGroup.builder().addModifiers(ModifierTypeInfos.PUBLIC).build();
    private static final TestAccessEvaluator EMPTY_ACCESS_EVALUATOR = new TestAccessEvaluator();

    @Test
    public void testArgumentTypeNotVisible() {
        Object argumentType = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("ArgType")).setModifiers(ModifierGroups.PRIVATE)).buildResolved();
        GenericTypeInfo list = GenericTypeInfoFactory.createList(argumentType);
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(EMPTY_ACCESS_EVALUATOR, TestConstants.FOO, list, false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testUnreifiedTypeNotVisible() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("GFoo")).setModifiers(ModifierGroups.PRIVATE)).setTypeArguments(ArgumentTypeInfos.T).buildResolved();
        GenericTypeInfo realType = GenericTypeInfoFactory.create((TypeInfo)type, TypeInfos.INTEGER);
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(EMPTY_ACCESS_EVALUATOR, TestConstants.FOO, realType, false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGenericTypeVisible() {
        GenericTypeInfo list = GenericTypeInfoFactory.createList(TypeInfos.INTEGER);
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(EMPTY_ACCESS_EVALUATOR, TestConstants.FOO, list, false), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPrivateField() {
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setDefiningType(TestConstants.FOO)).setType(TypeInfos.STRING)).setName("field")).setModifiers(ModifierGroups.PRIVATE)).build();
        MatcherAssert.assertThat((Object)Visibility.isMemberVisible(TestConstants.BAR, field, false, Visibility.CheckType.NO_CHECK), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPublicField() {
        Object field = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setDefiningType(TestConstants.FOO)).setType(TypeInfos.STRING)).setName("field")).setModifiers(PUBLIC_GROUP)).build();
        MatcherAssert.assertThat((Object)Visibility.isMemberVisible(TestConstants.BAR, field, false, Visibility.CheckType.NO_CHECK), (Matcher)Matchers.is((Object)true));
    }

    @DataProvider
    Object[][] getHighestVisibilityModifierData() {
        return new Object[][]{{new ModifierTypeInfo[]{ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.PROTECTED, ModifierTypeInfos.PRIVATE}, ModifierTypeInfos.GLOBAL}, {new ModifierTypeInfo[]{ModifierTypeInfos.PUBLIC, ModifierTypeInfos.PROTECTED, ModifierTypeInfos.PRIVATE}, ModifierTypeInfos.PUBLIC}, {new ModifierTypeInfo[]{ModifierTypeInfos.PROTECTED, ModifierTypeInfos.PRIVATE}, ModifierTypeInfos.PROTECTED}, {new ModifierTypeInfo[]{ModifierTypeInfos.PRIVATE}, ModifierTypeInfos.PRIVATE}};
    }

    @Test(dataProvider="getHighestVisibilityModifierData")
    public void testValidGetHighestVisibilityModifier(ModifierTypeInfo[] inputs, ModifierTypeInfo expectedHighestVisibility) {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(inputs).build();
        MatcherAssert.assertThat((Object)Visibility.getHighestVisibilityModifier(modifiers), (Matcher)Matchers.is((Object)expectedHighestVisibility));
    }
}

