/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.common.iterable.ExtendedTypeIterable;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectListPeelInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableLookupMode;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrders;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VariableResolver {
    private final SymbolResolver symbols;
    private final TypeInfo referencingType;
    private final TypeInfo label;

    public VariableResolver(SymbolResolver symbols, TypeInfo referencingType) {
        this.symbols = symbols;
        this.referencingType = referencingType;
        this.label = symbols.getLabelTypeInfo(Namespaces.EMPTY);
    }

    private VariableLookupMode getMode(IdentifierContext context, TypeInfo type) {
        switch (context) {
            case STATIC: {
                return VariableLookupMode.STATICS_FIRST;
            }
            case OBJECT: {
                return VariableLookupMode.INSTANCE_FIRST;
            }
        }
        return this.symbols.staticContext().get() && type == this.referencingType ? VariableLookupMode.STATICS_FIRST_LOCALS : VariableLookupMode.INSTANCE_FIRST_LOCALS;
    }

    public Variable lookup(IdentifierContext context, TypeInfo type, Identifier name) {
        List<Variable> variables = this.lookup(context, type, Collections.singletonList(name));
        return variables.isEmpty() ? null : variables.get(0);
    }

    public List<Variable> lookup(IdentifierContext context, TypeInfo type, List<Identifier> names) {
        TypeInfo currentType = type;
        ArrayList<Variable> variables = Lists.newArrayList();
        VariableLookupMode currentMode = this.getMode(context, type);
        for (Identifier name : names) {
            Variable variable = this.lookup(currentMode, currentType, name);
            variable = variable != null ? variable : this.attemptSpecialCaseVariableBinds(currentType, variables, name);
            currentMode = VariableLookupMode.INSTANCE_FIRST;
            if (variable == null) break;
            currentType = variable.getType();
            variables.add(variable);
        }
        return Collections.unmodifiableList(variables);
    }

    private Variable attemptSpecialCaseVariableBinds(TypeInfo currentType, List<Variable> variables, Identifier name) {
        FieldInfo fieldInfo;
        assert (variables.isEmpty() || Iterables.getLast(variables).getType().equals(currentType));
        if (SObjectTypeInfoUtil.isSObjectList(currentType) && (fieldInfo = CollectionTypeInfoUtil.getElementType(currentType).fields().get(this.symbols, this.referencingType, name.value, false)) != null) {
            return new SObjectListPeelInfo(currentType, fieldInfo);
        }
        return null;
    }

    private Variable lookup(VariableLookupMode mode, TypeInfo type, Identifier name) {
        if (mode.areLocalsAllowed() && type == this.referencingType) {
            FieldInfo enclosingField;
            LocalInfo localInfo = this.symbols.variables().lookup(name.value, name.loc);
            if (localInfo != null) {
                return localInfo;
            }
            if (type.getEnclosingType() != null && (enclosingField = type.getEnclosingType().fields().get(this.symbols, this.referencingType, name.value, true)) != null && (enclosingField.getModifiers().has(ModifierTypeInfos.STATIC) || type.getEnclosingType().getUnitType() == UnitType.TRIGGER)) {
                return enclosingField;
            }
        }
        for (TypeInfo current : new ExtendedTypeIterable(type)) {
            FieldInfo fieldInfo = current.fields().get(this.symbols, this.referencingType, name.value, mode.areStaticsFirst());
            if (fieldInfo == null) continue;
            return fieldInfo;
        }
        return null;
    }

    public StaticResult lookupStatic(List<Identifier> names, ReferenceType callerReferenceType) {
        for (int i = 1; i <= TypeNameResolutionOrders.DEFAULT.size() && i < names.size(); ++i) {
            List<Variable> variables;
            TypeInfo staticType = this.symbols.lookupTypeInfoIdentifiers(this.referencingType, names.subList(0, i));
            if (!staticType.isResolved() || (variables = this.lookup(IdentifierContext.STATIC, staticType, names.subList(i, names.size()))).isEmpty()) continue;
            if (TypeInfoEquivalence.isEquivalent(staticType, this.label)) {
                if (i + 1 != names.size() || callerReferenceType != ReferenceType.METHOD) continue;
                return new StaticResult(i, variables);
            }
            return new StaticResult(i, variables);
        }
        return new StaticResult(-1, Collections.emptyList());
    }

    public static class StaticResult {
        public final int position;
        public final List<Variable> variables;

        public StaticResult(int position, List<Variable> variables) {
            this.position = position;
            this.variables = variables;
        }
    }
}

