/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtFactory;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.JavaRef;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.naming.TypeNameParser;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.TestSymbolProvider;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.Version;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StandardSymbolResolverTest {
    private static final LocalInfo LOCAL_FOO = LocalInfo.builder().setName(JadtTester.FOO_ID.value).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final AbstractFieldInfo STATIC_FOO = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).build();
    private static final AbstractFieldInfo INSTANCE_FOO = ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName(JadtTester.FOO_ID.value)).setDefiningType(InternalTypeInfos.APEX_OBJECT)).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).build();
    private static final TypeInfo UNRESOLVED_FOO = UnresolvedTypeInfoFactory.create("foo");
    private static final TypeRef FOO_REF = TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("foo"), JadtTester.NO_TYPES);
    private static final TypeRef INTEGER_REF = TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("integer"), JadtTester.NO_TYPES);
    private SymbolResolver symbols;
    @Mock
    private SourceFile source;
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo otherType;
    private LocalVariableScope locals;

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.source.getNamespace()).thenReturn((Object)Namespaces.EMPTY);
        this.type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"FooClass"))).setParents(ParentTable.EMPTY)).build();
        this.otherType = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"OtherClass"))).setParents(ParentTable.EMPTY)).build();
        this.symbols = TestSymbolResolvers.createTestSymbols();
        this.locals = new LocalVariableScope();
        ApexCompiler compiler = ApexCompiler.builder().setInput(new CompilationInput(Collections.emptyList(), new TestSymbolProvider(), new TestAccessEvaluator(), new TestQueryValidators.Noop(), null)).build();
        this.symbols = new StandardSymbolResolver(compiler);
    }

    @Test
    public void testLookupFieldOnVariable() {
        LocalInfo localFooType = LocalInfo.builder().setName("foo").setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(this.type).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        this.type.fields().add(INSTANCE_FOO);
        this.type.fields().resolve();
        this.symbols.variables().push(this.locals);
        this.symbols.variables().add(localFooType).throwIfError();
        this.symbols.staticContext().set(false);
        MatcherAssert.assertThat(this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, Arrays.asList(JadtTester.FOO_ID, JadtTester.FOO_ID)), (Matcher)IsIterableContainingInOrder.contains((Object[])new Variable[]{localFooType, INSTANCE_FOO}));
    }

    @Test
    public void testLookupLocalVariableHigherPrecedence() {
        this.symbols.variables().push(this.locals);
        this.symbols.staticContext().set(false);
        this.symbols.variables().add(LOCAL_FOO).throwIfError();
        this.type.fields().add(INSTANCE_FOO).throwIfError();
        this.type.fields().resolve();
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)LOCAL_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.not((Object)INSTANCE_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.OBJECT, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)INSTANCE_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.STATIC, this.type, JadtTester.FOO_ID), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testStaticContextGivesPrecedenceToStaticInSameType() {
        this.type.fields().add(INSTANCE_FOO).throwIfError();
        this.type.fields().add(STATIC_FOO).throwIfError();
        this.type.fields().resolve();
        this.symbols.staticContext().set(false);
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)INSTANCE_FOO));
        this.symbols.staticContext().clear();
        this.symbols.staticContext().set(true);
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)STATIC_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.otherType, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)INSTANCE_FOO));
    }

    @Test
    public void testLookupLocalVariable() {
        this.symbols.variables().push(this.locals);
        this.symbols.staticContext().set(false);
        this.symbols.variables().add(LOCAL_FOO).throwIfError();
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)LOCAL_FOO));
    }

    @Test
    public void testLookupField() {
        this.type.fields().add(INSTANCE_FOO).throwIfError();
        this.symbols.staticContext().set(false);
        this.type.fields().resolve();
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.OBJECT, this.type, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)INSTANCE_FOO));
    }

    @Test
    public void testLocalVariablesNotCalledForOtherTypeFields() {
        this.symbols.variables().push(this.locals);
        this.symbols.staticContext().set(false);
        this.symbols.variables().add(LOCAL_FOO);
        StandardTypeInfoImpl otherType = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"BarClass"))).setParents(ParentTable.EMPTY)).build();
        otherType.fields().add(INSTANCE_FOO);
        otherType.fields().resolve();
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, (TypeInfo)otherType, JadtTester.FOO_ID), (Matcher)Matchers.is((Object)INSTANCE_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupVariableInfo(this.type, IdentifierContext.NONE, (TypeInfo)otherType, JadtTester.FOO_ID), (Matcher)Matchers.is((Matcher)Matchers.not((Object)LOCAL_FOO)));
    }

    @DataProvider
    Object[][] lookupTypeInfoForInternalTypeData() {
        return new Object[][]{{InternalTypeInfos.SYSTEM_ITERATOR, TestStandardTypeInfos.ITERATOR}, {InternalTypeInfos.SYSTEM_STATUS_CODE, TestStandardTypeInfos.STATUS_CODE}};
    }

    @Test(dataProvider="lookupTypeInfoForInternalTypeData")
    public void testLookupTypeInfoForInternalTypes(InternalTypeInfo internalType, TypeInfo realType) {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, internalType), IsType.isType(realType));
    }

    @DataProvider
    Object[][] fetchTypeInfoData() {
        return new Object[][]{{new TypeNameParser.TypeName(TypeInfos.INTEGER.getBytecodeName(), new TypeNameParser.TypeName[0]), TypeInfos.INTEGER}, {new TypeNameParser.TypeName(TypeInfos.LIST.getBytecodeName(), new TypeNameParser.TypeName(TypeInfos.OBJECT.getBytecodeName(), new TypeNameParser.TypeName[0])), ReifiedTypeInfos.OBJECT_LIST}, {new TypeNameParser.TypeName(TypeInfos.SET.getBytecodeName(), new TypeNameParser.TypeName(TypeInfos.OBJECT.getBytecodeName(), new TypeNameParser.TypeName[0])), ReifiedTypeInfos.OBJECT_SET}, {new TypeNameParser.TypeName(TypeInfos.SET.getBytecodeName(), new TypeNameParser.TypeName(TypeInfos.OBJECT.getBytecodeName(), new TypeNameParser.TypeName[0])), ReifiedTypeInfos.OBJECT_SET}};
    }

    @Test(dataProvider="fetchTypeInfoData")
    public void testFetchInfo(TypeNameParser.TypeName typeName, TypeInfo expected) {
        MatcherAssert.assertThat((Object)this.symbols.lookupInjectedTypeInfo((TypeInfo)TypeInfos.INTEGER, typeName.toString()), IsType.isType(expected));
        MatcherAssert.assertThat((Object)this.symbols.lookupInjectedTypeInfo((TypeInfo)TypeInfos.INTEGER, typeName), IsType.isType(expected));
    }

    @Test
    public void testArrayRef() {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ArrayTypeRef(JadtTester.NO_LOC, INTEGER_REF)), IsType.isType(ReifiedTypeInfos.INTEGER_LIST));
    }

    @Test
    public void testJavaRefTrusted() {
        Mockito.when((Object)this.source.isTrusted()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(Optional.of(JavaRef._JavaRef(JadtTester.NO_LOC)), JadtFactory.identifiers("foo"), JadtTester.NO_TYPES)), IsType.isType(UNRESOLVED_FOO));
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(Optional.of(JavaRef._JavaRef(JadtTester.NO_LOC)), JadtFactory.identifiers("java.lang.Integer"), JadtTester.NO_TYPES)), IsType.isType(TypeInfos.INTEGER));
    }

    @Test
    public void testJavaRefNotTrusted() {
        Mockito.when((Object)this.source.isTrusted()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(Optional.of(JavaRef._JavaRef(JadtTester.NO_LOC)), JadtFactory.identifiers("java.lang.Integer"), JadtTester.NO_TYPES)), IsType.isType(UnresolvedTypeInfoFactory.create("java", "lang", "Integer")));
    }

    @Test
    public void testUnresolvedType() {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, FOO_REF), IsType.isType(UnresolvedTypeInfoFactory.create("foo")));
    }

    @Test
    public void testUnresolvedParameterType() {
        TypeInfo list = this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("List"), JadtTester.optionalTypes((TypeRef[])new TypeRef[]{FOO_REF})));
        MatcherAssert.assertThat((Object)list, IsType.isType(UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, UNRESOLVED_FOO)));
    }

    @Test
    public void testUnresolvedMismatchParameterType() {
        TypeInfo list = this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("List"), JadtTester.optionalTypes((TypeRef[])new TypeRef[]{INTEGER_REF, INTEGER_REF})));
        MatcherAssert.assertThat((Object)list, IsType.isType(UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, TypeInfos.INTEGER, TypeInfos.INTEGER)));
    }

    @Test
    public void testUnresolvedNotGenericType() {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("integer"), JadtTester.optionalTypes((TypeRef[])new TypeRef[]{INTEGER_REF}))), IsType.isType(UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.INTEGER, TypeInfos.INTEGER)));
    }

    @Test
    public void testVersionedParameters() {
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.MIN);
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("integer"), JadtTester.optionalTypes((TypeRef[])new TypeRef[]{FOO_REF}))), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("integer"), JadtTester.optionalTypes((TypeRef[])new TypeRef[]{INTEGER_REF}))), IsType.isType(TypeInfos.INTEGER));
    }

    @Test
    public void testUnresolvedNoParameterTypes() {
        GenericTypeInfo expected = UnresolvedTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, new TypeInfo[0]);
        TypeInfo actual = this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("List"), JadtTester.NO_TYPES));
        MatcherAssert.assertThat((Object)actual, IsType.isType(expected));
    }

    @Test
    public void testUnresolvedArrayType() {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfo(this.type, TypeRef._ClassTypeRef(JadtTester.NO_JAVA_REF, JadtFactory.identifiers("java.lang.Integer"), JadtTester.NO_TYPES)), IsType.isType(UnresolvedTypeInfoFactory.create("java", "lang", "Integer")));
    }

    @Test
    public void testUnresolvedNamesTooLarge() {
        MatcherAssert.assertThat((Object)this.symbols.lookupTypeInfoIdentifiers(this.type, Arrays.asList(JadtFactory.identifier("Name1"), JadtFactory.identifier("Name2"), JadtFactory.identifier("Name3"), JadtFactory.identifier("Name4"), JadtFactory.identifier("Name5"))), IsType.isType(UnresolvedTypeInfoFactory.create("Name1", "Name2", "Name3", "Name4", "Name5")));
    }

    @Test
    public void testSoftBindLookupLabelNamespace() {
        ((TestSymbolProvider)this.symbols.getSymbolProvider()).addLabelField("", "foo");
        ((TestSymbolProvider)this.symbols.getSymbolProvider()).addLabelField("foo", "foo");
        VariableResolver.StaticResult field = this.symbols.lookupStaticVariableInfo(this.type, JadtFactory.identifiers("label", "foo"), ReferenceType.LOAD);
        MatcherAssert.assertThat(field.variables, (Matcher)Matchers.empty());
    }
}

