/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.util.StringUtil;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilerService;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldTables;
import apex.jorje.semantic.symbol.member.variable.LocalVariableTable;
import apex.jorje.semantic.symbol.member.variable.TriggerVariable;
import apex.jorje.semantic.symbol.member.variable.TriggerVariableMap;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.FieldContext;
import apex.jorje.semantic.symbol.resolver.MethodResolver;
import apex.jorje.semantic.symbol.resolver.StaticContext;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionGroup;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrder;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrders;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveRule;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameParser;
import apex.jorje.services.Version;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardSymbolResolver
implements SymbolResolver {
    private final ApexCompiler compiler;
    private final Map<String, TypeInfo> compiledTypesByLowerName;
    private final TriggerVariableMap triggerVariableMap;
    private final Map<String, TypeInfo> labelTypes;
    private final TypeInfo pageType;
    private final Map<InternalTypeInfo, TypeInfo> internalTypeToActualType;

    public StandardSymbolResolver(ApexCompiler compiler) {
        this.compiler = compiler;
        this.compiledTypesByLowerName = new CaseInsensitiveMap<TypeInfo>();
        this.labelTypes = new CaseInsensitiveMap<TypeInfo>();
        this.triggerVariableMap = new TriggerVariableMap();
        this.pageType = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("System.Page")).setBytecodeName("com/salesforce/api/System/Page")).setModifiers(ModifierGroups.HIDDEN)).setFields(DynamicFieldTables.createPageTable())).buildResolved();
        this.internalTypeToActualType = new HashMap<InternalTypeInfo, TypeInfo>();
    }

    @Override
    public TypeInfo lookupTypeInfo(TypeInfo referencingType, InternalTypeInfo type) {
        return this.internalTypeToActualType.computeIfAbsent(type, keyType -> {
            TypeInfo realType = this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.DEFAULT, keyType.getLookupName());
            assert (realType != null) : "The real type was not provided for: " + type;
            return realType;
        });
    }

    @Override
    public TypeInfo lookupInjectedTypeInfo(TypeInfo referencingType, String bytecodeName) {
        return this.lookupInjectedTypeInfo(referencingType, TypeNameParser.parseBytecodeName(bytecodeName));
    }

    @Override
    public TypeInfo lookupInjectedTypeInfo(TypeInfo referencingType, TypeNameParser.TypeName typeName) {
        TypeInfo type = this.findFullyQualified(referencingType, typeName.name.toLowerCase());
        if (typeName.arguments.isEmpty()) {
            return type;
        }
        List<TypeInfo> builder = typeName.arguments.stream().map(typeArgument -> this.lookupInjectedTypeInfo(referencingType, (TypeNameParser.TypeName)typeArgument)).collect(MoreIterables.toUnmodifiableList(typeName.arguments.size()));
        return GenericTypeInfoFactory.create(type, builder);
    }

    @Override
    public TypeInfo lookupTypeInfo(final TypeInfo referencingType, TypeRef typeRef) {
        return typeRef.match(new TypeRef.MatchBlock<TypeInfo>(){

            @Override
            public TypeInfo _case(TypeRef.ClassTypeRef typeRef) {
                return typeRef.javaRef.map(javaRef -> {
                    if (referencingType.getCodeUnitDetails().isTrusted()) {
                        Class clazz = JavaTypeInfoUtil.get().lookupClass(PrinterUtil.get().getFactory().dottedIdentifier().print(typeRef.className, new PrintContext()));
                        return clazz == null ? UnresolvedTypeInfoFactory.createFromIdentifiers(typeRef.className) : JavaTypeInfoUtil.get().createJava((Class<?>)clazz);
                    }
                    return UnresolvedTypeInfoFactory.createFromIdentifiers(typeRef.className);
                }).orElseGet(() -> {
                    TypeInfo type = StandardSymbolResolver.this.lookupTypeInfoIdentifiers(referencingType, typeRef.className);
                    return typeRef.typeArguments.map(arguments -> {
                        if (Version.V184.isGreaterThan(referencingType.getCodeUnitDetails().getVersion()) && !arguments.isEmpty() && !GenericTypeInfoUtil.isGenericType(type)) {
                            return type;
                        }
                        List<TypeInfo> types = arguments.stream().map(value -> StandardSymbolResolver.this.lookupTypeInfo(referencingType, (TypeRef)value)).collect(MoreIterables.toUnmodifiableList(arguments.size()));
                        return GenericTypeInfoFactory.create(type, types);
                    }).orElseGet(() -> GenericTypeInfoUtil.isGenericType(type) ? UnresolvedTypeInfoFactory.create(type, new TypeInfo[0]) : type);
                });
            }

            @Override
            public TypeInfo _case(TypeRef.ArrayTypeRef typeRef) {
                TypeInfo heldType = StandardSymbolResolver.this.lookupTypeInfo(referencingType, typeRef.heldType);
                return GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, heldType);
            }
        });
    }

    @Override
    public TypeInfo lookupTypeInfoIdentifiers(TypeInfo referencingType, List<Identifier> names) {
        return this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.DEFAULT, names.stream().map(StringUtil.IDENTIFIER_TO_NAME).collect(MoreIterables.toUnmodifiableList(names.size())));
    }

    @Override
    public TypeInfo lookupTypeInfoIdentifiers(TypeInfo referencingType, List<Identifier> identifiers, ReferenceType reference) {
        List<String> names = identifiers.stream().map(StringUtil.IDENTIFIER_TO_NAME).collect(MoreIterables.toUnmodifiableList(identifiers.size()));
        return this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.get(reference), names);
    }

    @Override
    public Result<MethodInfo> lookupMethodInfo(TypeInfo referencingType, IdentifierContext context, TypeInfo type, Signature signature) {
        return new MethodResolver(referencingType).lookup(context, type, signature);
    }

    @Override
    public Variable lookupVariableInfo(TypeInfo referencingType, IdentifierContext context, TypeInfo type, Identifier name) {
        return new VariableResolver(this, referencingType).lookup(context, type, name);
    }

    @Override
    public List<Variable> lookupVariableInfo(TypeInfo referencingType, IdentifierContext context, TypeInfo type, List<Identifier> names) {
        return new VariableResolver(this, referencingType).lookup(context, type, names);
    }

    @Override
    public VariableResolver.StaticResult lookupStaticVariableInfo(TypeInfo referencingType, List<Identifier> names, ReferenceType referenceType) {
        return new VariableResolver(this, referencingType).lookupStatic(names, referenceType);
    }

    @Override
    public boolean add(TypeInfo type) {
        if (!this.compiledTypesByLowerName.containsKey(type.getBytecodeName())) {
            this.compiledTypesByLowerName.put(type.getBytecodeName().toLowerCase(), type);
            return false;
        }
        return true;
    }

    @Override
    public TypeInfo get(String fullNameLower) {
        return this.compiledTypesByLowerName.get(fullNameLower);
    }

    @Override
    public LocalVariableTable variables() {
        return this.compiler.getCompilerContext().variables();
    }

    @Override
    public StaticContext staticContext() {
        return this.compiler.getCompilerContext().staticContext();
    }

    @Override
    public FieldContext fields() {
        return this.compiler.getCompilerContext().fieldContext();
    }

    @Override
    public SymbolProvider getSymbolProvider() {
        return this.compiler.getInput().getSymbolProvider();
    }

    @Override
    public AccessEvaluator getAccessEvaluator() {
        return this.compiler.getInput().getAccessEvaluator();
    }

    @Override
    public QueryValidator getQueryValidator() {
        return this.compiler.getInput().getQueryValidator();
    }

    @Override
    public CompilerService getCompilerService() {
        return this.compiler;
    }

    @Override
    public TriggerVariable getTriggerVariable(TypeInfo referencingType, String name) {
        TypeInfo targetType = TypeInfoUtil.getTopLevel(referencingType).getCodeUnitDetails().getTriggerType().resolve(this, referencingType);
        return targetType == null || !targetType.isResolved() ? null : this.triggerVariableMap.get(referencingType, targetType, name);
    }

    @Override
    public TypeInfo getLabelTypeInfo(Namespace namespace) {
        TypeInfo type = this.labelTypes.get(namespace.toString());
        if (type == null) {
            type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("System.Label")).setBytecodeName("com/salesforce/api/System/Label")).setModifiers(ModifierGroups.HIDDEN)).setBasicType(BasicType.APEX_OBJECT)).setNamespace(Namespaces.SYSTEM)).setFields(DynamicFieldTables.createLabelTable(namespace))).buildResolved();
            this.labelTypes.put(namespace.toString(), type);
        }
        return type;
    }

    @Override
    public TypeInfo getPageTypeInfo() {
        return this.pageType;
    }

    private TypeInfo lookupTypeInfo(TypeInfo referencingType, TypeNameResolutionOrder order, List<String> names) {
        List<String> lowerNames = names.stream().map(StringUtil.TO_LOWER_NAME).collect(MoreIterables.toUnmodifiableList(names.size()));
        if (!TypeNameResolutionOrders.DEFAULT.hasRule(names.size())) {
            return UnresolvedTypeInfoFactory.create(names);
        }
        TypeNameResolutionGroup group = order.getRule(lowerNames.size());
        Version version = referencingType.getCodeUnitDetails().getVersion();
        Predicate isApplicable = rule -> rule.isApplicableToVersion(version);
        for (TypeNameResolveRule rule2 : Collections2.filter(group.getRules(), isApplicable)) {
            TypeInfo type = rule2.lookup(this, referencingType, lowerNames);
            if (type == null) continue;
            assert (type.isResolved());
            return type;
        }
        return UnresolvedTypeInfoFactory.create(names);
    }

    private TypeInfo findFullyQualified(TypeInfo referencingType, String lowerCaseFullName) {
        assert (StringUtil.isLowerCase(lowerCaseFullName));
        TypeInfo type = this.compiledTypesByLowerName.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = TypeInfoTables.TYPES_BY_BYTECODE_NAME.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = this.compiler.getInput().getSymbolProvider().find(this, referencingType, lowerCaseFullName);
        if (type != null) {
            return type;
        }
        return UnresolvedTypeInfoFactory.create(lowerCaseFullName);
    }

    public TypeInfo find(TypeInfo referencingType, String lowerCaseFullName) {
        assert (StringUtil.isLowerCase(lowerCaseFullName));
        TypeInfo type = TypeInfoTables.WRAPPER_TYPES.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        if (this.pageType.getBytecodeName().equalsIgnoreCase(lowerCaseFullName)) {
            return this.pageType;
        }
        type = this.compiledTypesByLowerName.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = this.compiler.getInput().getSymbolProvider().find(this, referencingType, lowerCaseFullName);
        if (type != null) {
            return type;
        }
        return null;
    }
}

