/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class NamespaceVisibilityTest {
    private static final AccessEvaluator NAMESPACE_NOT_VISIBLE_EVALUATOR = new TestAccessEvaluator(){

        @Override
        public boolean isAccessibleOrTrustedNamespace(Namespace namespace) {
            return false;
        }
    };

    @Test
    public void testInaccessibleNamespace() {
        StandardTypeInfoImpl nonEmptyNamespace = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("ArgType")).setNamespace(TestConstants.NAMESPACE_A)).build();
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(NAMESPACE_NOT_VISIBLE_EVALUATOR, TestConstants.FOO, nonEmptyNamespace, false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testVisibleIfInSameInaccessibleNamespace() {
        StandardTypeInfoImpl typeAInNamespaceA = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("TypeA")).setNamespace(TestConstants.NAMESPACE_A)).build();
        StandardTypeInfoImpl typeBInNamespaceA = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("TypeB")).setNamespace(TestConstants.NAMESPACE_A)).build();
        MatcherAssert.assertThat((Object)Visibility.isTypeVisible(NAMESPACE_NOT_VISIBLE_EVALUATOR, typeAInNamespaceA, typeBInNamespaceA, false), (Matcher)Matchers.is((Object)true));
    }
}

