/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Version;

class MethodResolver {
    private final TypeInfo referencingType;

    public MethodResolver(TypeInfo referencingType) {
        this.referencingType = referencingType;
    }

    public Result<MethodInfo> lookup(IdentifierContext context, TypeInfo type, Signature signature) {
        Version version = this.referencingType.getCodeUnitDetails().getVersion();
        if (signature.isConstructor()) {
            return type.methods().getApproximate(version, signature, MethodLookupMode.CONSTRUCTORS);
        }
        Result<MethodInfo> result = Result.none();
        switch (context) {
            case OBJECT: 
            case NONE: {
                result = this.lookupInstance(version, type, signature);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupStatic(version, type, signature);
                break;
            }
            case STATIC: {
                result = this.lookupStatic(version, type, signature);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupInstance(version, type, signature);
            }
        }
        if (result.hasResult()) {
            return result;
        }
        if (type.getEnclosingType() != null && (result = this.lookupStatic(version, type.getEnclosingType(), signature)).hasResult()) {
            return result;
        }
        return result;
    }

    private Result<MethodInfo> lookupStatic(Version version, TypeInfo type, Signature signature) {
        if (type.getBasicType() == BasicType.SOBJECT) {
            return type.methods().getApproximate(version, signature, MethodLookupMode.STATICS);
        }
        for (TypeInfo current : new SuperTypeIterable(type)) {
            Result<MethodInfo> method = current.methods().getApproximate(version, signature, MethodLookupMode.STATICS);
            if (!method.hasResult()) continue;
            return method;
        }
        return Result.none();
    }

    private Result<MethodInfo> lookupInstance(Version version, TypeInfo type, Signature signature) {
        return type.virtualMethods().getApproximate(version, signature, MethodLookupMode.INSTANCE);
    }
}

