/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DistanceTest {
    private static final JavaTypeInfo JAVA_TYPE = JavaTypeInfo.create(Foo.class);
    private static final TypeInfo ID_TO_OBJECT = GenericTypeInfoFactory.createMap(TypeInfos.ID, TypeInfos.OBJECT);
    private static final TypeInfo OBJECT_TO_ID = GenericTypeInfoFactory.createMap(TypeInfos.OBJECT, TypeInfos.ID);
    private static final TypeInfo OBJECT_TO_STRING = GenericTypeInfoFactory.createMap(TypeInfos.OBJECT, TypeInfos.STRING);
    private static final TypeInfo ID_SET = GenericTypeInfoFactory.createSet(TypeInfos.ID);
    private static final TypeInfo STRING_SET = GenericTypeInfoFactory.createSet(TypeInfos.STRING);
    private static final TypeInfo JAVA_OBJECT = JavaTypeInfoUtil.get().createJava((Class<?>)Object.class);
    private static final TypeInfo JAVA_STRING = JavaTypeInfoUtil.get().createJava((Class<?>)String.class);
    private static final TypeInfo JAVA_BOOLEAN = JavaTypeInfoUtil.get().createJava((Class<?>)Boolean.TYPE);
    private static final TypeInfo JAVA_NUMBER = JavaTypeInfoUtil.get().createJava((Class<?>)Number.class);
    private static final TypeInfo JAVA_FOO = JavaTypeInfoUtil.get().createJava((Class<?>)Foo.class);
    private static final TypeInfo ENUM_FOO = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyEnum((String)"Foo"))).setParents(InternalTypeInfos.ENUM)).buildResolved();
    private static final TypeInfo CLASS_BAR = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).buildResolved();
    private static final TypeInfo CLASS_BAZ = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("baz")).buildResolved();
    private static final TypeInfo CLASS_FOO_T_EXTENDS_BAR = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setParents(CLASS_BAR)).buildResolved();
    private static final TypeInfo INTERFACE_BAR = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).setUnitType(UnitType.INTERFACE)).buildResolved();
    private static final TypeInfo CLASS_FOO_T_IMPLEMENTS_BAR = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setParents(TestStandardTypeInfos.APEX_OBJECT, INTERFACE_BAR)).buildResolved();
    private static final TypeInfo CLASS_FOO_T = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setParents(TestStandardTypeInfos.APEX_OBJECT)).buildResolved();
    private static final TypeInfo CLASS_BAR_EXTENDS_FOO_INTEGER = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).setParents(GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.INTEGER))).buildResolved();
    private static final TypeInfo CLASS_BAR_EXTENDS_FOO_STRING = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).setParents(GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.STRING))).buildResolved();
    private static final TypeInfo INTERFACE_FOO_T = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setApexBytecodeName("foo")).setTypeArguments(ArgumentTypeInfos.T).setUnitType(UnitType.INTERFACE)).buildResolved();
    private static final TypeInfo CLASS_BAR_IMPLEMENTS_FOO_INTEGER = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).setParents(TestStandardTypeInfos.APEX_OBJECT, GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.INTEGER))).buildResolved();
    private static final TypeInfo CLASS_BAR_IMPLEMENTS_FOO_STRING = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("bar")).setParents(TestStandardTypeInfos.APEX_OBJECT, GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.STRING))).buildResolved();
    private static final TypeInfo CLASS_FOO_IN_BAZ = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("baz.foo")).setBytecodeName("baz/foo")).setEnclosingType(CLASS_BAZ)).buildResolved();
    private static final TypeInfo CLASS_FOO_IN_BAR = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("bar.foo")).setBytecodeName("bar/foo")).setEnclosingType(CLASS_BAR)).buildResolved();
    private static final SObjectTypeInfo OTHER_ACCOUNT = (SObjectTypeInfo)((SObjectTypeInfo.Builder)SObjectTypeInfo.builder().setApexName("Account")).buildResolved();
    @Spy
    private JavaTypeInfoUtil util;
    private Distance distance;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.distance = new Distance(this.util);
    }

    @DataProvider
    Object[][] getDistancesData() {
        return new Object[][]{{ImmutableList.of(JAVA_STRING, JAVA_BOOLEAN), ImmutableList.of(JAVA_OBJECT, JAVA_OBJECT), new int[]{1, 1}}, {ImmutableList.of(TypeInfos.STRING, TypeInfos.STRING), ImmutableList.of(JAVA_OBJECT, JAVA_OBJECT), new int[]{10, 10}}};
    }

    @Test(dataProvider="getDistancesData")
    public void testGetDistances(List<TypeInfo> inputTypes, List<TypeInfo> targetTypes, int[] expected) {
        MatcherAssert.assertThat((Object)this.distance.getDistance(Version.CURRENT, inputTypes, targetTypes), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] getDistanceData() {
        return new Object[][]{{Version.V150, TypeInfos.DECIMAL, TypeInfos.DOUBLE, 2}, {Version.V152, TypeInfos.DECIMAL, TypeInfos.DOUBLE, -1}};
    }

    @Test(dataProvider="getDistanceData")
    public void testGetDistance(Version version, TypeInfo inputTypes, TypeInfo targetTypes, int expected) {
        MatcherAssert.assertThat((Object)this.distance.getDistance(version, inputTypes, targetTypes), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] isCloserData() {
        return new Object[][]{{null, null, 0}, {new int[0], null, -1}, {new int[0], new int[0], 0}, {new int[]{3, 4, 5}, new int[]{1, 2, 3}, 6}};
    }

    @Test(dataProvider="isCloserData")
    public void testIsCloser(int[] left, int[] right, int expected) {
        MatcherAssert.assertThat((Object)this.distance.isCloser(left, right), (Matcher)Matchers.is((Object)expected));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testCantCallIsCloserWithLeftNull() {
        this.distance.isCloser(null, new int[0]);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testLeftAndRightMustHaveEqualLength() {
        this.distance.isCloser(new int[0], new int[]{1});
    }

    @DataProvider
    Object[][] getCommonTypeData() {
        return new Object[][]{{TypeInfos.ID, TypeInfos.STRING, TypeInfos.ID}, {TypeInfos.STRING, TypeInfos.ID, TypeInfos.ID}, {TypeInfos.ID, JAVA_STRING, TypeInfos.ID}, {TypeInfos.STRING, TypeInfos.STRING, TypeInfos.STRING}, {TypeInfos.ID, TypeInfos.ID, TypeInfos.ID}, {TypeInfos.STRING, JAVA_STRING, TypeInfos.STRING}, {TypeInfos.INTEGER, TypeInfos.DOUBLE, TypeInfos.DOUBLE}, {TypeInfos.DOUBLE, TypeInfos.INTEGER, TypeInfos.DOUBLE}, {TypeInfos.STRING, TypeInfos.INTEGER, null}, {TypeInfos.STRING, TypeInfos.OBJECT, TypeInfos.OBJECT}, {TypeInfos.OBJECT, TypeInfos.STRING, TypeInfos.OBJECT}, {TypeInfos.OBJECT, JAVA_OBJECT, JAVA_OBJECT}, {JAVA_OBJECT, TypeInfos.OBJECT, TypeInfos.OBJECT}, {TypeInfos.STRING, JAVA_OBJECT, JAVA_OBJECT}, {JAVA_OBJECT, TypeInfos.STRING, JAVA_OBJECT}, {TypeInfos.DOUBLE, TypeInfos.DECIMAL, TypeInfos.DECIMAL}, {TypeInfos.DECIMAL, TypeInfos.DOUBLE, TypeInfos.DECIMAL}};
    }

    @Test(dataProvider="getCommonTypeData")
    public void testGetCommonType(TypeInfo left, TypeInfo right, TypeInfo expected) {
        TypeSafeDiagnosingMatcher<TypeInfo> matcher = expected == null ? Matchers.nullValue(TypeInfo.class) : IsType.isType(expected);
        MatcherAssert.assertThat((Object)this.distance.getCommonType(Version.CURRENT, left, right), matcher);
    }

    @DataProvider
    Object[][] canAssignData() {
        return new Object[][]{{ArgumentTypeInfos.T, TypeInfos.STRING, false}, {TypeInfos.STRING, ArgumentTypeInfos.T, false}, {InternalTypeInfos.ENUM, ENUM_FOO, false}, {ENUM_FOO, InternalTypeInfos.ENUM, true}, {JAVA_NUMBER, TypeInfos.INTEGER, false}, {TypeInfos.INTEGER, JAVA_NUMBER, true}, {JAVA_BOOLEAN, TypeInfos.BOOLEAN, true}, {TypeInfos.BOOLEAN, JAVA_BOOLEAN, true}, {TypeInfos.STRING, JAVA_STRING, true}, {JAVA_STRING, TypeInfos.STRING, true}, {TypeInfos.ID, JAVA_STRING, true}, {JAVA_STRING, TypeInfos.ID, true}, {TypeInfos.ID, TypeInfos.STRING, true}, {TypeInfos.STRING, TypeInfos.ID, true}, {TypeInfos.DOUBLE, TypeInfos.DECIMAL, true}, {TypeInfos.DECIMAL, TypeInfos.DOUBLE, true}, {TypeInfos.INTEGER, TypeInfos.DOUBLE, true}, {TypeInfos.DOUBLE, TypeInfos.INTEGER, false}, {TypeInfos.STRING, TypeInfos.INTEGER, false}, {TypeInfos.STRING, TypeInfos.OBJECT, true}, {TypeInfos.OBJECT, TypeInfos.STRING, false}, {TestVfTypeInfos.APEX_PAGE, TestStandardTypeInfos.APEX_PAGES_COMPONENT, true}, {TestStandardTypeInfos.APEX_PAGES_COMPONENT, TestVfTypeInfos.APEX_PAGE, false}, {TypeInfos.OBJECT, JAVA_OBJECT, true}, {JAVA_OBJECT, TypeInfos.OBJECT, true}, {TypeInfos.STRING, JAVA_OBJECT, true}, {JAVA_OBJECT, TypeInfos.STRING, false}, {ReifiedTypeInfos.INTEGER_LIST, TypeInfos.OBJECT, true}, {TypeInfos.OBJECT, ReifiedTypeInfos.INTEGER_LIST, false}, {GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, TypeInfos.DECIMAL), GenericTypeInfoFactory.create((TypeInfo)TypeInfos.LIST, TypeInfos.DOUBLE), true}, {GenericTypeInfoFactory.create((TypeInfo)TypeInfos.MAP, TypeInfos.STRING, TypeInfos.DECIMAL), GenericTypeInfoFactory.create((TypeInfo)TypeInfos.MAP, TypeInfos.STRING, TypeInfos.DOUBLE), true}, {TypeInfos.LIST, ReifiedTypeInfos.STRING_LIST, true}, {ReifiedTypeInfos.STRING_LIST, TypeInfos.LIST, true}, {OBJECT_TO_STRING, TypeInfos.MAP, true}, {TypeInfos.MAP, OBJECT_TO_STRING, true}, {STRING_SET, TypeInfos.SET, true}, {TypeInfos.SET, STRING_SET, true}, {JAVA_FOO, TypeInfos.OBJECT, true}, {TypeInfos.OBJECT, JAVA_FOO, false}, {CLASS_BAR_IMPLEMENTS_FOO_INTEGER, GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.INTEGER), true}, {CLASS_BAR_IMPLEMENTS_FOO_STRING, GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.INTEGER), false}, {GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.INTEGER), CLASS_BAR_IMPLEMENTS_FOO_INTEGER, false}, {GenericTypeInfoFactory.create(INTERFACE_FOO_T, TypeInfos.INTEGER), CLASS_BAR_IMPLEMENTS_FOO_STRING, false}, {CLASS_BAR_EXTENDS_FOO_INTEGER, GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.INTEGER), true}, {CLASS_BAR_EXTENDS_FOO_STRING, GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.INTEGER), false}, {GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.INTEGER), CLASS_BAR_EXTENDS_FOO_INTEGER, false}, {GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.INTEGER), CLASS_BAR_EXTENDS_FOO_STRING, false}, {GenericTypeInfoFactory.create(CLASS_FOO_T_EXTENDS_BAR, TypeInfos.INTEGER), CLASS_BAR, true}, {CLASS_BAR, GenericTypeInfoFactory.create(CLASS_FOO_T_EXTENDS_BAR, TypeInfos.INTEGER), false}, {GenericTypeInfoFactory.create(CLASS_FOO_T_IMPLEMENTS_BAR, TypeInfos.INTEGER), INTERFACE_BAR, true}, {INTERFACE_BAR, GenericTypeInfoFactory.create(CLASS_FOO_T_IMPLEMENTS_BAR, TypeInfos.INTEGER), false}, {ID_SET, STRING_SET, false}, {STRING_SET, ID_SET, false}, {ReifiedTypeInfos.ID_LIST, ReifiedTypeInfos.STRING_LIST, true}, {ReifiedTypeInfos.STRING_LIST, ReifiedTypeInfos.ID_LIST, true}, {ReifiedTypeInfos.STRING_TO_OBJECT_MAP, ID_TO_OBJECT, false}, {ID_TO_OBJECT, ReifiedTypeInfos.STRING_TO_OBJECT_MAP, false}, {OBJECT_TO_ID, OBJECT_TO_STRING, true}, {OBJECT_TO_STRING, OBJECT_TO_ID, true}, {GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.STRING), GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.ID), false}, {GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.ID), GenericTypeInfoFactory.create(CLASS_FOO_T, TypeInfos.STRING), false}, {TypeInfos.DATE, TypeInfos.DATE_TIME, true}, {TypeInfos.DATE_TIME, TypeInfos.DATE, false}, {TypeInfos.TIME, TypeInfos.DATE_TIME, false}, {TypeInfos.DATE_TIME, TypeInfos.TIME, false}, {TypeInfos.DATE, TypeInfos.TIME, false}, {TypeInfos.TIME, TypeInfos.DATE, false}, {TypeInfos.STRING, InternalTypeInfos.NULL, false}, {InternalTypeInfos.NULL, TypeInfos.STRING, true}, {TestSObjectTypeInfos.ACCOUNT, TypeInfos.SOBJECT, true}, {TypeInfos.SOBJECT, TestSObjectTypeInfos.ACCOUNT, false}, {TestSObjectTypeInfos.ACCOUNT_LIST, ReifiedTypeInfos.SOBJECT_LIST, true}, {ReifiedTypeInfos.SOBJECT_LIST, TestSObjectTypeInfos.ACCOUNT_LIST, true}, {GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TestSObjectTypeInfos.ACCOUNT), TestSObjectTypeInfos.ACCOUNT_LIST, false}, {GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TypeInfos.SOBJECT), TestSObjectTypeInfos.ACCOUNT_LIST, false}, {TestSObjectTypeInfos.ACCOUNT_LIST, GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TestSObjectTypeInfos.ACCOUNT), true}, {TestSObjectTypeInfos.ACCOUNT_LIST, GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TypeInfos.SOBJECT), true}, {GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TypeInfos.STRING), TestSObjectTypeInfos.ACCOUNT_LIST, false}, {GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERABLE, TypeInfos.STRING), CLASS_BAR_IMPLEMENTS_FOO_STRING, false}, {TestStandardTypeInfos.ITERATOR, WrapperTypeInfos.SYSTEM_LIST_ITERATOR, false}, {WrapperTypeInfos.SYSTEM_LIST_ITERATOR, TestStandardTypeInfos.ITERATOR, true}, {GenericTypeInfoFactory.create((TypeInfo)WrapperTypeInfos.SYSTEM_LIST_ITERATOR, TypeInfos.STRING), GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERATOR, TypeInfos.STRING), true}, {GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERATOR, TypeInfos.STRING), GenericTypeInfoFactory.create((TypeInfo)WrapperTypeInfos.SYSTEM_LIST_ITERATOR, TypeInfos.STRING), false}, {GenericTypeInfoFactory.create((TypeInfo)WrapperTypeInfos.SYSTEM_LIST_ITERATOR, TypeInfos.STRING), GenericTypeInfoFactory.create(TestStandardTypeInfos.ITERATOR, TypeInfos.INTEGER), false}, {TestSObjectTypeInfos.ACCOUNT_LIST, OTHER_ACCOUNT, true}};
    }

    @Test(dataProvider="canAssignData")
    public void testCanAssign(TypeInfo inputType, TypeInfo targetType, boolean expected) {
        MatcherAssert.assertThat((Object)this.distance.canAssign(Version.CURRENT, inputType, targetType), (Matcher)Matchers.is((Object)expected));
    }

    @DataProvider
    Object[][] canAssignDataVersioned() {
        return new Object[][]{{Version.V158, CLASS_FOO_IN_BAR, CLASS_FOO_IN_BAZ, true}, {Version.V158, CLASS_FOO_IN_BAZ, CLASS_FOO_IN_BAR, true}, {Version.V160, CLASS_FOO_IN_BAR, CLASS_FOO_IN_BAZ, false}, {Version.V160, CLASS_FOO_IN_BAZ, CLASS_FOO_IN_BAR, false}, {Version.V162, TestSObjectTypeInfos.ACCOUNT, TypeInfos.OBJECT, false}, {Version.V164, TestSObjectTypeInfos.ACCOUNT, TypeInfos.OBJECT, true}};
    }

    @Test(dataProvider="canAssignDataVersioned")
    public void testCanAssignVersioned(Version version, TypeInfo left, TypeInfo right, boolean expected) {
        MatcherAssert.assertThat((Object)this.distance.canAssign(version, left, right), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testSfdcMapValueToApexMap() {
        Mockito.when((Object)this.util.fromJavaType(Foo.class, JavaTypeInfoUtil.TypeUsage.AS_PARAMETER)).thenReturn((Object)ReifiedTypeInfos.STRING_TO_STRING_MAP);
        MatcherAssert.assertThat((Object)this.distance.canAssign(Version.CURRENT, (TypeInfo)JAVA_TYPE, (TypeInfo)ReifiedTypeInfos.STRING_TO_STRING_MAP), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distance.canAssign(Version.CURRENT, (TypeInfo)ReifiedTypeInfos.STRING_TO_STRING_MAP, (TypeInfo)JAVA_TYPE), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSfdcApexObjectToObject() {
        Mockito.when((Object)this.util.fromJavaType(Foo.class, JavaTypeInfoUtil.TypeUsage.AS_PARAMETER)).thenReturn((Object)TypeInfos.OBJECT);
        MatcherAssert.assertThat((Object)this.distance.canAssign(Version.CURRENT, (TypeInfo)JAVA_TYPE, (TypeInfo)TypeInfos.OBJECT), (Matcher)Matchers.is((Object)true));
    }

    private static class Foo {
        private Foo() {
        }
    }
}

