/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.FlowInterviewTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.Version;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Distance {
    private static final Distance INSTANCE = new Distance();
    private final JavaTypeInfoUtil util;

    private Distance() {
        this(JavaTypeInfoUtil.get());
    }

    Distance(JavaTypeInfoUtil util) {
        this.util = util;
    }

    public static Distance get() {
        return INSTANCE;
    }

    public int[] getDistance(Version applicableVersion, List<TypeInfo> inputTypes, List<TypeInfo> targetTypes) {
        assert (inputTypes.size() == targetTypes.size());
        int[] distances = new int[inputTypes.size()];
        for (int i = 0; i < inputTypes.size(); ++i) {
            distances[i] = this.getDistance(applicableVersion, inputTypes.get(i), targetTypes.get(i));
            if (distances[i] >= 0) continue;
            return null;
        }
        return distances;
    }

    public int isCloser(int[] left, int[] right) {
        if (left == null && right == null) {
            return 0;
        }
        assert (left != null);
        if (right == null) {
            return -1;
        }
        assert (left.length == right.length);
        int leftTotal = 0;
        int rightTotal = 0;
        for (int i = 0; i < left.length; ++i) {
            leftTotal += left[i];
            rightTotal += right[i];
        }
        return leftTotal - rightTotal;
    }

    public TypeInfo getCommonType(TypeInfo referencingType, TypeInfo left, TypeInfo right) {
        return this.getCommonType(referencingType.getCodeUnitDetails().getVersion(), left, right);
    }

    TypeInfo getCommonType(Version applicableVersion, TypeInfo left, TypeInfo right) {
        if (TypeInfoEquivalence.isEquivalent(left, right)) {
            return left;
        }
        if ((TypeInfoEquivalence.isEquivalent(left, TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(left, TypeInfos.ID)) && (TypeInfoEquivalence.isEquivalent(right, TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(right, TypeInfos.ID))) {
            return TypeInfos.ID;
        }
        if ((TypeInfoEquivalence.isEquivalent(left, TypeInfos.DOUBLE) || TypeInfoEquivalence.isEquivalent(left, TypeInfos.DECIMAL)) && (TypeInfoEquivalence.isEquivalent(right, TypeInfos.DOUBLE) || TypeInfoEquivalence.isEquivalent(right, TypeInfos.DECIMAL))) {
            return TypeInfos.DECIMAL;
        }
        if (this.getDistance(applicableVersion, left, right) >= 0) {
            return right;
        }
        if (this.getDistance(applicableVersion, right, left) >= 0) {
            return left;
        }
        return null;
    }

    public boolean canAssign(TypeInfo referencingType, TypeInfo inputType, TypeInfo targetType) {
        return this.canAssign(referencingType.getCodeUnitDetails().getVersion(), inputType, targetType);
    }

    public boolean canAssign(Version applicableVersion, TypeInfo inputType, TypeInfo targetType) {
        if (TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.OBJECT) && inputType.getBasicType() == BasicType.SOBJECT && applicableVersion.isLessThan(Version.V164)) {
            return false;
        }
        return TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.DOUBLE) && TypeInfoEquivalence.isEquivalent(inputType, TypeInfos.DECIMAL) || this.getDistance(applicableVersion, inputType, targetType) >= 0;
    }

    public int getDistance(TypeInfo referencingType, TypeInfo inputType, TypeInfo targetType) {
        return this.getDistance(referencingType.getCodeUnitDetails().getVersion(), inputType, targetType);
    }

    public int getDistance(Version applicableVersion, TypeInfo inputType, TypeInfo targetType) {
        if (TypeInfoEquivalence.isEquivalent(inputType, targetType)) {
            return 0;
        }
        if (TypeInfoEquivalence.isEquivalent(inputType, InternalTypeInfos.NULL)) {
            return targetType.getBasicType() == BasicType.JAVA ? 2 : 1;
        }
        if (!inputType.isResolved() || !targetType.isResolved()) {
            return -1;
        }
        if (TypeInfoEquivalence.isEquivalent(targetType, TypeInfos.OBJECT)) {
            return 10;
        }
        SecondaryDistanceTypeVisitor innerVisitor = inputType.accept(CalculateDistanceInputTypeVisitor.INSTANCE);
        innerVisitor.inject(this);
        innerVisitor.inject(applicableVersion);
        return targetType.accept(innerVisitor);
    }

    private int getDistanceJavaToApex(Version applicableVersion, JavaTypeInfo javaType, TypeInfo apexType) {
        TypeInfo apexEquivalentType = this.util.fromJavaType(this.util.getBoxedType(javaType.getJavaType()), JavaTypeInfoUtil.TypeUsage.AS_PARAMETER);
        if (apexEquivalentType == null) {
            Class<?> javaEquivalentType = this.util.fromApexType(apexType);
            return javaEquivalentType == null ? -1 : (javaEquivalentType.isAssignableFrom(javaType.getJavaType()) ? 1 : -1);
        }
        return this.getDistance(applicableVersion, apexEquivalentType, apexType);
    }

    private int getDistanceApexToJava(Version applicableVersion, TypeInfo apexType, JavaTypeInfo javaType) {
        TypeInfo apexEquivalentType = this.util.fromJavaType(this.util.getBoxedType(javaType.getJavaType()), JavaTypeInfoUtil.TypeUsage.AS_PARAMETER);
        if (apexEquivalentType == null) {
            if (apexType.getUnitType() == UnitType.ENUM && javaType.getJavaType().getName().equals("common.apex.runtime.ApexValue$EnumValue")) {
                return 1;
            }
            Class<?> javaEquivalentType = this.util.fromApexType(apexType);
            return javaEquivalentType == null ? -1 : (javaType.getJavaType().isAssignableFrom(javaEquivalentType) ? 1 : -1);
        }
        return this.getDistance(applicableVersion, apexType, apexEquivalentType);
    }

    private boolean isJavaTypeAssignableToClass(Class<?> targetClazz, Class<?> inputClazz) {
        return this.util.getBoxedType(targetClazz).isAssignableFrom(this.util.getBoxedType(inputClazz));
    }

    private Integer ancestry(Version applicableVersion, TypeInfo inputType, TypeInfo targetType) {
        TypeInfo superType;
        if (targetType.getUnitType() == UnitType.INTERFACE) {
            for (TypeInfo interfaceType : inputType.parents().immediateInterfaces()) {
                int distance = this.getDistance(applicableVersion, interfaceType, targetType);
                if (distance < 0) continue;
                return 1 + distance;
            }
        }
        if ((superType = inputType.parents().superType()) == null) {
            return -1;
        }
        int distance = this.getDistance(applicableVersion, inputType.parents().superType(), targetType);
        if (distance >= 0) {
            return 1 + distance;
        }
        return -1;
    }

    private static class ArgumentTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private ArgumentTypeVisitor() {
        }
    }

    private static class InputGenericTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final GenericTypeInfo inputType;

        InputGenericTypeVisitor(GenericTypeInfo inputType) {
            this.inputType = inputType;
        }

        private Integer getGenericDistance(TypeInfo targetType, List<TypeInfo> targetArguments) {
            int distance = this.distance.getDistance(this.applicableVersion, this.inputType.getRootUnreifiedType(), targetType);
            if (distance < 0) {
                return distance;
            }
            int[] distances = this.distance.getDistance(this.applicableVersion, this.inputType.getTypeArguments(), targetArguments);
            if (distances == null) {
                return -1;
            }
            for (int argumentDistance : distances) {
                if (argumentDistance == 0) continue;
                return -1;
            }
            return 0;
        }

        private int getMapDistance(GenericTypeInfo type) {
            if (!TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getKeyType(this.inputType), CollectionTypeInfoUtil.getKeyType(type))) {
                return -1;
            }
            return this.distance.canAssign(this.applicableVersion, CollectionTypeInfoUtil.getValueType(this.inputType), CollectionTypeInfoUtil.getValueType(type)) ? 1 : -1;
        }

        private int getListDistance(TypeInfo targetElementType) {
            int elementDistance;
            TypeInfo inputElementType = CollectionTypeInfoUtil.getElementType(this.inputType);
            int n = elementDistance = this.distance.canAssign(this.applicableVersion, inputElementType, targetElementType) ? 1 : -1;
            if (inputElementType.equals(TypeInfos.SOBJECT) && targetElementType.getBasicType() == BasicType.SOBJECT) {
                return 1;
            }
            return elementDistance;
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(InternalTypeInfo type) {
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(ScalarTypeInfo type) {
            if (type.getBasicType() == BasicType.SOBJECT) {
                if (SObjectTypeInfoUtil.isGenericSObjectList(this.inputType)) {
                    return 1;
                }
                if (SObjectTypeInfoUtil.isConcreteSObjectList(this.inputType)) {
                    return 2;
                }
            }
            return -1;
        }

        @Override
        public Integer visit(SObjectTypeInfo type) {
            if (SObjectTypeInfoUtil.isGenericSObjectList(this.inputType)) {
                return 2;
            }
            if (SObjectTypeInfoUtil.isConcreteSObjectList(this.inputType) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(this.inputType), type)) {
                return 1;
            }
            return -1;
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            return this.distance.getDistanceApexToJava(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(GenericTypeInfo type) {
            if (type.getUnreifiedType() == null || this.inputType.getUnreifiedType() == null) {
                boolean equivalent = type.getUnreifiedType() == null && this.inputType.getUnreifiedType() != null ? TypeInfoEquivalence.isEquivalent(type, this.inputType.getRootUnreifiedType()) : type.getUnreifiedType() != null && TypeInfoEquivalence.isEquivalent(type.getRootUnreifiedType(), this.inputType);
                return equivalent ? 1 : this.distance.ancestry(this.applicableVersion, this.inputType, type);
            }
            if (CollectionTypeInfoUtil.isList(this.inputType) && this.distance.getDistance(this.applicableVersion, this.inputType.getRootUnreifiedType(), type.getRootUnreifiedType()) >= 0) {
                return this.getListDistance(CollectionTypeInfoUtil.getElementType(type));
            }
            if (CollectionTypeInfoUtil.isMap(this.inputType) && CollectionTypeInfoUtil.isMap(type)) {
                return this.getMapDistance(type);
            }
            return this.getGenericDistance(type.getUnreifiedType(), type.getTypeArguments());
        }
    }

    private static class FlowInterviewTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final TypeInfo inputType;

        public FlowInterviewTypeVisitor(TypeInfo inputType) {
            this.inputType = inputType;
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return TypeInfoEquivalence.isEquivalent(this.inputType.parents().superType(), type) ? 1 : -1;
        }

        @Override
        public Integer visit(InternalTypeInfo type) {
            return TypeInfoEquivalence.isEquivalent(this.inputType.parents().superType(), type) ? 1 : -1;
        }
    }

    private static class VfComponentTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final TypeInfo inputType;

        public VfComponentTypeVisitor(TypeInfo inputType) {
            this.inputType = inputType;
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            return this.distance.getDistanceApexToJava(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return TypeInfoEquivalence.isEquivalent(this.inputType.parents().superType(), type) ? 1 : -1;
        }

        @Override
        public Integer visit(InternalTypeInfo type) {
            return TypeInfoEquivalence.isEquivalent(this.inputType.parents().superType(), type) ? 1 : -1;
        }
    }

    private static class InputJavaTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final JavaTypeInfo inputType;

        public InputJavaTypeVisitor(JavaTypeInfo inputType) {
            this.inputType = inputType;
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            if (this.distance.isJavaTypeAssignableToClass(type.getJavaType(), this.inputType.getJavaType())) {
                return 1;
            }
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return this.distance.getDistanceJavaToApex(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(ScalarTypeInfo type) {
            if (TypeInfoEquivalence.isEquivalent(type, TypeInfos.ID) && this.distance.getDistanceJavaToApex(this.applicableVersion, this.inputType, TypeInfos.STRING) >= 0) {
                return 1;
            }
            return this.distance.getDistanceJavaToApex(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(GenericTypeInfo type) {
            if (CollectionTypeInfoUtil.isCollection(type)) {
                if (CollectionTypeInfoUtil.isList(type) && this.distance.isJavaTypeAssignableToClass(List.class, this.inputType.getJavaType())) {
                    return 1;
                }
                if (CollectionTypeInfoUtil.isSet(type) && this.distance.isJavaTypeAssignableToClass(Set.class, this.inputType.getJavaType())) {
                    return 1;
                }
                return this.distance.getDistanceJavaToApex(this.applicableVersion, this.inputType, type);
            }
            if (CollectionTypeInfoUtil.isMap(type)) {
                if (this.distance.isJavaTypeAssignableToClass(Map.class, this.inputType.getJavaType())) {
                    return 1;
                }
                return this.distance.getDistanceJavaToApex(this.applicableVersion, this.inputType, type);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class InputInternalTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final InternalTypeInfo inputType;

        InputInternalTypeVisitor(InternalTypeInfo inputType) {
            this.inputType = inputType;
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }
    }

    private static class InputSObjectTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final SObjectTypeInfo inputType;

        InputSObjectTypeVisitor(SObjectTypeInfo inputType) {
            this.inputType = inputType;
        }

        @Override
        public Integer visit(SObjectTypeInfo type) {
            return TypeInfoEquivalence.isEquivalent(this.inputType, type) ? 0 : -1;
        }

        @Override
        public Integer visit(ScalarTypeInfo type) {
            return type.getBasicType() == BasicType.SOBJECT ? 1 : -1;
        }
    }

    private static class InputAnnotationTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private InputAnnotationTypeVisitor() {
        }
    }

    private static class InputScalarTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final ScalarTypeInfo inputType;

        InputScalarTypeVisitor(ScalarTypeInfo inputType) {
            this.inputType = inputType;
        }

        private static boolean allowDownCastingOfDecimal(Version version) {
            return version.isLessThan(Version.V152);
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            if (TypeInfoEquivalence.isEquivalent(this.inputType, TypeInfos.ID) && this.distance.getDistanceJavaToApex(this.applicableVersion, type, TypeInfos.STRING) >= 0) {
                return 1;
            }
            return this.distance.getDistanceApexToJava(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(ScalarTypeInfo type) {
            switch (type.getBasicType()) {
                case ID: 
                case STRING: {
                    switch (this.inputType.getBasicType()) {
                        case ID: 
                        case STRING: {
                            return 1;
                        }
                    }
                    break;
                }
                case DECIMAL: {
                    switch (this.inputType.getBasicType()) {
                        case INTEGER: {
                            return 3;
                        }
                        case LONG: {
                            return 2;
                        }
                        case DOUBLE: {
                            return 1;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    if (InputScalarTypeVisitor.allowDownCastingOfDecimal(this.applicableVersion)) {
                        switch (this.inputType.getBasicType()) {
                            case INTEGER: {
                                return 4;
                            }
                            case LONG: {
                                return 3;
                            }
                            case DECIMAL: {
                                return 2;
                            }
                        }
                        break;
                    }
                    switch (this.inputType.getBasicType()) {
                        case INTEGER: {
                            return 2;
                        }
                        case LONG: {
                            return 1;
                        }
                    }
                    break;
                }
                case LONG: {
                    switch (this.inputType.getBasicType()) {
                        case INTEGER: {
                            return 1;
                        }
                    }
                    break;
                }
                case DATE_TIME: {
                    switch (this.inputType.getBasicType()) {
                        case DATE: {
                            return 2;
                        }
                    }
                }
            }
            return -1;
        }
    }

    private static class InputStandardTypeVisitor
    extends SecondaryDistanceTypeVisitor {
        private final StandardTypeInfo inputType;

        InputStandardTypeVisitor(StandardTypeInfo inputType) {
            this.inputType = inputType;
        }

        private boolean isVersionedInnerTypeRule(StandardTypeInfo type) {
            if (TypeInfoUtil.isInnerType(type) && TypeInfoUtil.isInnerType(this.inputType) && this.applicableVersion.isLessThan(Version.V160)) {
                int indexDotInput = this.inputType.getApexName().indexOf(46);
                assert (indexDotInput != -1);
                int indexDotType = type.getApexName().indexOf(46);
                assert (indexDotType != -1);
                return this.inputType.getApexName().regionMatches(true, indexDotInput, type.getApexName(), indexDotType, type.getApexName().length() - indexDotType);
            }
            return false;
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return this.isVersionedInnerTypeRule(type) ? 0 : this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            return this.distance.getDistanceApexToJava(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(InternalTypeInfo type) {
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }

        @Override
        public Integer visit(GenericTypeInfo type) {
            return this.distance.ancestry(this.applicableVersion, this.inputType, type);
        }
    }

    private static abstract class SecondaryDistanceTypeVisitor
    implements TypeInfoVisitor<Integer> {
        Version applicableVersion;
        Distance distance;

        private SecondaryDistanceTypeVisitor() {
        }

        void inject(Version applicableVersion) {
            this.applicableVersion = applicableVersion;
        }

        void inject(Distance distance) {
            this.distance = distance;
        }

        @Override
        public Integer visit(StandardTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(SObjectTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(JavaTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(GenericTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(VfComponentTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(FlowInterviewTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(ScalarTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(ModifierOrAnnotationTypeInfo type) {
            return -1;
        }

        @Override
        public Integer visit(InternalTypeInfo type) {
            return -1;
        }

        @Override
        public final Integer visit(ArgumentTypeInfo type) {
            return -1;
        }
    }

    private static class CalculateDistanceInputTypeVisitor
    implements TypeInfoVisitor<SecondaryDistanceTypeVisitor> {
        private static final CalculateDistanceInputTypeVisitor INSTANCE = new CalculateDistanceInputTypeVisitor();

        private CalculateDistanceInputTypeVisitor() {
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(StandardTypeInfo type) {
            return new InputStandardTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(SObjectTypeInfo type) {
            return new InputSObjectTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(VfComponentTypeInfo type) {
            return new VfComponentTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(FlowInterviewTypeInfo type) {
            return new FlowInterviewTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(JavaTypeInfo type) {
            return new InputJavaTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(ScalarTypeInfo type) {
            return new InputScalarTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(ModifierOrAnnotationTypeInfo type) {
            return new InputAnnotationTypeVisitor();
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(GenericTypeInfo type) {
            return new InputGenericTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(InternalTypeInfo type) {
            return new InputInternalTypeVisitor(type);
        }

        @Override
        public SecondaryDistanceTypeVisitor visit(ArgumentTypeInfo type) {
            return new ArgumentTypeVisitor();
        }
    }
}

